/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.ValidationMessage;
import org.apache.jasper.JasperException;
import org.apache.jasper.JasperMessages;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.TagConstants;
import org.apache.jasper.compiler.TagFileProcessor;
import org.apache.jasper.deploy.FunctionInfo;
import org.apache.jasper.deploy.TagAttributeInfo;
import org.apache.jasper.deploy.TagInfo;
import org.apache.jasper.deploy.TagLibraryValidatorInfo;
import org.apache.tomcat.util.scan.Jar;
import org.apache.tomcat.util.scan.JarFactory;

class TagLibraryInfoImpl
extends TagLibraryInfo
implements TagConstants {
    public static final int ABS_URI = 0;
    public static final int ROOT_REL_URI = 1;
    public static final int NOROOT_REL_URI = 2;
    private JspCompilationContext ctxt;
    private PageInfo pi;
    private ErrorDispatcher err;
    private ParserController parserController;
    protected TagLibraryValidator tagLibraryValidator;

    private final void print(String name, String value, PrintWriter w) {
        if (value != null) {
            w.print(name + " = {\n\t");
            w.print(value);
            w.print("\n}\n");
        }
    }

    public String toString() {
        int i;
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.print("tlibversion", this.tlibversion, out);
        this.print("jspversion", this.jspversion, out);
        this.print("shortname", this.shortname, out);
        this.print("urn", this.urn, out);
        this.print("info", this.info, out);
        this.print("uri", this.uri, out);
        this.print("tagLibraryValidator", "" + this.tagLibraryValidator, out);
        for (i = 0; i < this.tags.length; ++i) {
            out.println(this.tags[i].toString());
        }
        for (i = 0; i < this.tagFiles.length; ++i) {
            out.println(this.tagFiles[i].toString());
        }
        for (i = 0; i < this.functions.length; ++i) {
            out.println(this.functions[i].toString());
        }
        return sw.toString();
    }

    public TagLibraryInfoImpl(JspCompilationContext ctxt, ParserController pc, PageInfo pi, String prefix, String uriIn, String[] location, ErrorDispatcher err) throws JasperException {
        super(prefix, uriIn);
        this.ctxt = ctxt;
        this.parserController = pc;
        this.pi = pi;
        this.err = err;
        if (location == null && (location = this.generateTLDLocation(this.uri, ctxt)) != null) {
            this.uri = location[0];
        }
        URL jarFileUrl = null;
        if (location == null) {
            err.jspError(JasperMessages.MESSAGES.fileNotFound(uriIn), new String[0]);
        }
        if (location[0] != null && location[0].endsWith(".jar")) {
            try {
                URL jarUrl = ctxt.getServletContext().getResource(location[0]);
                if (jarUrl != null) {
                    jarFileUrl = new URL("jar:" + jarUrl + "!/");
                }
            }
            catch (MalformedURLException ex) {
                err.jspError(JasperMessages.MESSAGES.fileNotFound(uriIn), new String[0]);
            }
        }
        Jar jar = null;
        try {
            if (jarFileUrl != null) {
                jar = JarFactory.newInstance(jarFileUrl);
            }
        }
        catch (IOException e) {
            throw new JasperException(e);
        }
        org.apache.jasper.deploy.TagLibraryInfo tagLibraryInfo = (org.apache.jasper.deploy.TagLibraryInfo)((HashMap)ctxt.getServletContext().getAttribute("org.apache.jasper.JSP_TAG_LIBRARIES")).get(this.uri);
        if (tagLibraryInfo == null) {
            err.jspError(JasperMessages.MESSAGES.fileNotFound(uriIn), new String[0]);
        }
        ArrayList<javax.servlet.jsp.tagext.TagInfo> tagInfos = new ArrayList<javax.servlet.jsp.tagext.TagInfo>();
        ArrayList<TagFileInfo> tagFileInfos = new ArrayList<TagFileInfo>();
        HashMap<String, javax.servlet.jsp.tagext.FunctionInfo> functionInfos = new HashMap<String, javax.servlet.jsp.tagext.FunctionInfo>();
        this.jspversion = tagLibraryInfo.getJspversion();
        this.tlibversion = tagLibraryInfo.getTlibversion();
        this.shortname = tagLibraryInfo.getShortname();
        this.urn = tagLibraryInfo.getUri();
        this.info = tagLibraryInfo.getInfo();
        if (tagLibraryInfo.getValidator() != null) {
            this.tagLibraryValidator = this.createValidator(tagLibraryInfo);
        }
        TagInfo[] tagInfosArray = tagLibraryInfo.getTags();
        for (int i = 0; i < tagInfosArray.length; ++i) {
            javax.servlet.jsp.tagext.TagInfo tagInfo = this.createTagInfo(tagInfosArray[i]);
            tagInfos.add(tagInfo);
        }
        org.apache.jasper.deploy.TagFileInfo[] tagFileInfosArray = tagLibraryInfo.getTagFileInfos();
        for (int i = 0; i < tagFileInfosArray.length; ++i) {
            TagFileInfo tagFileInfo = this.createTagFileInfo(tagFileInfosArray[i], jar);
            tagFileInfos.add(tagFileInfo);
        }
        FunctionInfo[] functionInfosArray = tagLibraryInfo.getFunctionInfos();
        for (int i = 0; i < functionInfosArray.length; ++i) {
            javax.servlet.jsp.tagext.FunctionInfo functionInfo = this.createFunctionInfo(functionInfosArray[i]);
            if (functionInfos.containsKey(functionInfo.getName())) {
                err.jspError(JasperMessages.MESSAGES.duplicateTagLibraryFunctionName(functionInfo.getName(), this.uri), new String[0]);
            }
            functionInfos.put(functionInfo.getName(), functionInfo);
        }
        if (this.tlibversion == null) {
            err.jspError(JasperMessages.MESSAGES.missingRequiredTagLibraryElement("tlib-version", this.uri), new String[0]);
        }
        if (this.jspversion == null) {
            err.jspError(JasperMessages.MESSAGES.missingRequiredTagLibraryElement("jsp-version", this.uri), new String[0]);
        }
        this.tags = tagInfos.toArray(new javax.servlet.jsp.tagext.TagInfo[0]);
        this.tagFiles = tagFileInfos.toArray(new TagFileInfo[0]);
        this.functions = functionInfos.values().toArray(new javax.servlet.jsp.tagext.FunctionInfo[0]);
    }

    private String[] generateTLDLocation(String uri, JspCompilationContext ctxt) throws JasperException {
        int uriType = TagLibraryInfoImpl.uriType(uri);
        if (uriType == 0) {
            this.err.jspError(JasperMessages.MESSAGES.unresolvableAbsoluteUri(uri), new String[0]);
        } else if (uriType == 2 && (uri = ctxt.resolveRelativeUri(uri)) != null) {
            uri = this.normalize(uri);
        }
        String[] location = new String[2];
        location[0] = uri;
        if (location[0].endsWith("jar")) {
            URL url = null;
            try {
                url = ctxt.getResource(location[0]);
            }
            catch (Exception ex) {
                this.err.jspError(ex, JasperMessages.MESSAGES.errorAccessingJar(location[0]), new String[0]);
            }
            if (url == null) {
                this.err.jspError(JasperMessages.MESSAGES.missingJar(location[0]), new String[0]);
            }
            location[0] = url.toString();
            location[1] = "META-INF/taglib.tld";
        }
        return location;
    }

    private String normalize(String path) {
        return this.normalize(path, true);
    }

    private String normalize(String path, boolean replaceBackSlash) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (replaceBackSlash && normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (normalized.equals("/.")) {
            return "/";
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    public TagLibraryInfo[] getTagLibraryInfos() {
        Collection<TagLibraryInfo> coll = this.pi.getTaglibs();
        return coll.toArray(new TagLibraryInfo[0]);
    }

    protected javax.servlet.jsp.tagext.TagInfo createTagInfo(TagInfo tagInfo) throws JasperException {
        String tagBodyContent;
        ArrayList<javax.servlet.jsp.tagext.TagAttributeInfo> attributeInfos = new ArrayList<javax.servlet.jsp.tagext.TagAttributeInfo>();
        ArrayList<TagVariableInfo> variableInfos = new ArrayList<TagVariableInfo>();
        boolean dynamicAttributes = JspUtil.booleanValue(tagInfo.getDynamicAttributes());
        TagAttributeInfo[] attributeInfosArray = tagInfo.getTagAttributeInfos();
        for (int i = 0; i < attributeInfosArray.length; ++i) {
            javax.servlet.jsp.tagext.TagAttributeInfo attributeInfo = this.createTagAttributeInfo(attributeInfosArray[i]);
            attributeInfos.add(attributeInfo);
        }
        org.apache.jasper.deploy.TagVariableInfo[] variableInfosArray = tagInfo.getTagVariableInfos();
        for (int i = 0; i < variableInfosArray.length; ++i) {
            TagVariableInfo variableInfo = this.createTagVariableInfo(variableInfosArray[i]);
            variableInfos.add(variableInfo);
        }
        TagExtraInfo tei = null;
        String teiClassName = tagInfo.getTagExtraInfo();
        if (teiClassName != null && !teiClassName.equals("")) {
            try {
                Class<?> teiClass = this.ctxt.getClassLoader().loadClass(teiClassName);
                tei = (TagExtraInfo)teiClass.newInstance();
            }
            catch (Exception e) {
                this.err.jspError(e, JasperMessages.MESSAGES.errorLoadingTagExtraInfo(teiClassName), new String[0]);
            }
        }
        if ((tagBodyContent = tagInfo.getBodyContent()) == null) {
            tagBodyContent = "JSP";
        }
        return new javax.servlet.jsp.tagext.TagInfo(tagInfo.getTagName(), tagInfo.getTagClassName(), tagBodyContent, tagInfo.getInfoString(), (TagLibraryInfo)this, tei, attributeInfos.toArray(new javax.servlet.jsp.tagext.TagAttributeInfo[0]), tagInfo.getDisplayName(), tagInfo.getSmallIcon(), tagInfo.getLargeIcon(), variableInfos.toArray(new TagVariableInfo[0]), dynamicAttributes);
    }

    protected javax.servlet.jsp.tagext.TagAttributeInfo createTagAttributeInfo(TagAttributeInfo attributeInfo) {
        String type = attributeInfo.getType();
        String expectedType = attributeInfo.getExpectedTypeName();
        String methodSignature = attributeInfo.getMethodSignature();
        boolean rtexprvalue = JspUtil.booleanValue(attributeInfo.getReqTime());
        boolean fragment = JspUtil.booleanValue(attributeInfo.getFragment());
        boolean deferredValue = JspUtil.booleanValue(attributeInfo.getDeferredValue());
        boolean deferredMethod = JspUtil.booleanValue(attributeInfo.getDeferredMethod());
        boolean required = JspUtil.booleanValue(attributeInfo.getRequired());
        if (type != null && "1.2".equals(this.jspversion) && (type.equals("Boolean") || type.equals("Byte") || type.equals("Character") || type.equals("Double") || type.equals("Float") || type.equals("Integer") || type.equals("Long") || type.equals("Object") || type.equals("Short") || type.equals("String"))) {
            type = "java.lang." + type;
        }
        if (deferredValue) {
            type = "javax.el.ValueExpression";
            expectedType = expectedType != null ? expectedType.trim() : "java.lang.Object";
        }
        if (deferredMethod) {
            type = "javax.el.MethodExpression";
            methodSignature = methodSignature != null ? methodSignature.trim() : "java.lang.Object method()";
        }
        if (fragment) {
            type = "javax.servlet.jsp.tagext.JspFragment";
            rtexprvalue = true;
        }
        if (!rtexprvalue && type == null) {
            type = "java.lang.String";
        }
        return new javax.servlet.jsp.tagext.TagAttributeInfo(attributeInfo.getName(), required, type, rtexprvalue, fragment, attributeInfo.getDescription(), deferredValue, deferredMethod, expectedType, methodSignature);
    }

    protected TagVariableInfo createTagVariableInfo(org.apache.jasper.deploy.TagVariableInfo variableInfo) {
        String className;
        int scope = 0;
        String s = variableInfo.getScope();
        if (s != null) {
            if ("NESTED".equals(s)) {
                scope = 0;
            } else if ("AT_BEGIN".equals(s)) {
                scope = 1;
            } else if ("AT_END".equals(s)) {
                scope = 2;
            }
        }
        if ((className = variableInfo.getClassName()) == null) {
            className = "java.lang.String";
        }
        boolean declare = true;
        if (variableInfo.getDeclare() != null) {
            declare = JspUtil.booleanValue(variableInfo.getDeclare());
        }
        return new TagVariableInfo(variableInfo.getNameGiven(), variableInfo.getNameFromAttribute(), className, declare, scope);
    }

    protected TagFileInfo createTagFileInfo(org.apache.jasper.deploy.TagFileInfo tagFileInfo, Jar jar) throws JasperException {
        String name = tagFileInfo.getName();
        String path = tagFileInfo.getPath();
        if (path.startsWith("/META-INF/tags")) {
            this.ctxt.setTagFileJarUrl(path, jar.getJarFileURL());
        } else if (!path.startsWith("/WEB-INF/tags")) {
            this.err.jspError(JasperMessages.MESSAGES.invalidTagFileDirectory(path), new String[0]);
        }
        javax.servlet.jsp.tagext.TagInfo tagInfo = TagFileProcessor.parseTagFileDirectives(this.parserController, name, path, jar, this);
        return new TagFileInfo(name, path, tagInfo);
    }

    protected javax.servlet.jsp.tagext.FunctionInfo createFunctionInfo(FunctionInfo functionInfo) {
        return new javax.servlet.jsp.tagext.FunctionInfo(functionInfo.getName(), functionInfo.getFunctionClass(), functionInfo.getFunctionSignature());
    }

    public static int uriType(String uri) {
        if (uri.indexOf(58) != -1) {
            return 0;
        }
        if (uri.startsWith("/")) {
            return 1;
        }
        return 2;
    }

    private TagLibraryValidator createValidator(org.apache.jasper.deploy.TagLibraryInfo tagLibraryInfo) throws JasperException {
        TagLibraryValidatorInfo tlvInfo = tagLibraryInfo.getValidator();
        String validatorClass = tlvInfo.getValidatorClass();
        Map<String, Object> initParams = tlvInfo.getInitParams();
        TagLibraryValidator tlv = null;
        if (validatorClass != null && !validatorClass.equals("")) {
            try {
                Class<?> tlvClass = this.ctxt.getClassLoader().loadClass(validatorClass);
                tlv = (TagLibraryValidator)tlvClass.newInstance();
            }
            catch (Exception e) {
                this.err.jspError(e, JasperMessages.MESSAGES.errorLoadingTagLibraryValidator(validatorClass), new String[0]);
            }
        }
        if (tlv != null) {
            tlv.setInitParameters(initParams);
        }
        return tlv;
    }

    public TagLibraryValidator getTagLibraryValidator() {
        return this.tagLibraryValidator;
    }

    public ValidationMessage[] validate(PageData thePage) {
        TagLibraryValidator tlv = this.getTagLibraryValidator();
        if (tlv == null) {
            return null;
        }
        String uri = this.getURI();
        if (uri.startsWith("/")) {
            uri = "urn:jsptld:" + uri;
        }
        return tlv.validate(this.getPrefixString(), uri, thePage);
    }
}

