/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.adduser;

import java.util.ArrayList;
import java.util.Collection;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.adduser.AbstractValidationState;
import org.jboss.as.domain.management.security.adduser.AddUser;
import org.jboss.as.domain.management.security.adduser.ConfirmationChoice;
import org.jboss.as.domain.management.security.adduser.ConsoleWrapper;
import org.jboss.as.domain.management.security.adduser.ErrorState;
import org.jboss.as.domain.management.security.adduser.PreModificationState;
import org.jboss.as.domain.management.security.adduser.PromptNewUserState;
import org.jboss.as.domain.management.security.adduser.PromptPasswordState;
import org.jboss.as.domain.management.security.adduser.State;
import org.jboss.as.domain.management.security.adduser.StateValues;
import org.jboss.as.domain.management.security.password.PasswordCheckResult;
import org.jboss.as.domain.management.security.password.RestrictionLevel;

public class ValidatePasswordState
extends AbstractValidationState {
    private final StateValues stateValues;
    private final ConsoleWrapper theConsole;

    public ValidatePasswordState(ConsoleWrapper theConsole, StateValues stateValues) {
        this.theConsole = theConsole;
        this.stateValues = stateValues;
    }

    @Override
    protected Collection<State> getValidationStates() {
        ArrayList<State> validationStates;
        boolean relaxRestriction = RestrictionLevel.RELAX.equals((Object)this.stateValues.getOptions().getCheckUtil().getRestrictionLevel());
        if (!relaxRestriction && !this.stateValues.getOptions().isEnableDisableMode()) {
            validationStates = new ArrayList(1);
            validationStates.add(this.getDetailedCheckState());
        } else {
            validationStates = new ArrayList<State>(0);
        }
        return validationStates;
    }

    private State getRetryState() {
        return this.stateValues.isSilentOrNonInteractive() ? null : new PromptNewUserState(this.theConsole, this.stateValues);
    }

    private State getDetailedCheckState() {
        return new State(){

            @Override
            public State execute() {
                PasswordCheckResult result = ValidatePasswordState.this.stateValues.getOptions().getCheckUtil().check(false, ValidatePasswordState.this.stateValues.getUserName(), ValidatePasswordState.this.stateValues.getPassword());
                boolean warnResult = PasswordCheckResult.Result.WARN.equals((Object)result.getResult());
                boolean rejectResult = PasswordCheckResult.Result.REJECT.equals((Object)result.getResult());
                switch (ValidatePasswordState.this.stateValues.getOptions().getCheckUtil().getRestrictionLevel()) {
                    case WARN: {
                        if (!warnResult && !rejectResult || ValidatePasswordState.this.stateValues.isSilentOrNonInteractive()) break;
                        return ValidatePasswordState.this.confirmWeakPassword(result);
                    }
                    case REJECT: {
                        if (warnResult && !ValidatePasswordState.this.stateValues.isSilentOrNonInteractive()) {
                            return ValidatePasswordState.this.confirmWeakPassword(result);
                        }
                        if (!rejectResult) break;
                        return new ErrorState(ValidatePasswordState.this.theConsole, result.getMessage(), ValidatePasswordState.this.getRetryState(), ValidatePasswordState.this.stateValues);
                    }
                }
                return ValidatePasswordState.this;
            }
        };
    }

    private State confirmWeakPassword(PasswordCheckResult result) {
        if (this.stateValues.getOptions().isConfirmWarning()) {
            this.theConsole.printf(result.getMessage(), new Object[0]);
            this.theConsole.printf(DomainManagementLogger.ROOT_LOGGER.sureToSetPassword(), new Object[0]);
            this.theConsole.printf(AddUser.NEW_LINE, new Object[0]);
            return this;
        }
        String message = result.getMessage();
        String prompt = DomainManagementLogger.ROOT_LOGGER.sureToSetPassword();
        PromptNewUserState noState = new PromptNewUserState(this.theConsole, this.stateValues);
        return new ConfirmationChoice(this.theConsole, message, prompt, (State)this, (State)noState);
    }

    @Override
    protected State getSuccessState() {
        return this.stateValues.isInteractive() ? new PromptPasswordState(this.theConsole, this.stateValues, true) : new PreModificationState(this.theConsole, this.stateValues);
    }
}

