/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.threads.ArrayQueue;
import org.jboss.threads.BlockingExecutorService;
import org.jboss.threads.ExecutionInterruptedException;
import org.jboss.threads.ExecutionTimedOutException;

public final class OrderedExecutor
extends AbstractExecutorService
implements BlockingExecutorService {
    private final Executor parent;
    private final Runnable runner = new Runner();
    private final Lock lock = new ReentrantLock();
    private final Condition removeCondition = this.lock.newCondition();
    private final Queue<Runnable> queue;
    private boolean running;
    private boolean blocking;
    private Executor handoffExecutor;

    public OrderedExecutor(Executor parent) {
        this(parent, new ArrayDeque<Runnable>());
    }

    public OrderedExecutor(Executor parent, Queue<Runnable> queue) {
        this(parent, queue, true, null);
    }

    public OrderedExecutor(Executor parent, int queueLength) {
        this(parent, new ArrayQueue<Runnable>(queueLength), true, null);
    }

    public OrderedExecutor(Executor parent, int queueLength, Executor handoffExecutor) {
        this(parent, new ArrayQueue<Runnable>(queueLength), false, handoffExecutor);
    }

    public OrderedExecutor(Executor parent, Queue<Runnable> queue, boolean blocking, Executor handoffExecutor) {
        if (parent == null) {
            throw new NullPointerException("parent is null");
        }
        if (queue == null) {
            throw new NullPointerException("queue is null");
        }
        this.queue = queue;
        this.parent = parent;
        this.blocking = blocking;
        this.handoffExecutor = handoffExecutor;
    }

    public OrderedExecutor(Executor parent, int queueLength, boolean blocking, Executor handoffExecutor) {
        this(parent, new ArrayQueue<Runnable>(queueLength), blocking, handoffExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable task) {
        Executor executor;
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        while (true) {
            this.lock.lock();
            try {
                if (!this.running) {
                    this.running = true;
                    boolean ok = false;
                    try {
                        this.parent.execute(this.runner);
                        ok = true;
                    }
                    finally {
                        if (!ok) {
                            this.running = false;
                        }
                    }
                }
                if (!this.queue.offer(task)) {
                    if (this.blocking) {
                        try {
                            this.removeCondition.await();
                            continue;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new ExecutionInterruptedException();
                        }
                    }
                    executor = this.handoffExecutor;
                    break;
                }
                return;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
        if (executor != null) {
            executor.execute(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBlocking(Runnable task) throws RejectedExecutionException, InterruptedException {
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        while (true) {
            this.lock.lock();
            try {
                if (!this.running) {
                    this.running = true;
                    boolean ok = false;
                    try {
                        this.parent.execute(this.runner);
                        ok = true;
                    }
                    finally {
                        if (!ok) {
                            this.running = false;
                        }
                    }
                }
                if (!this.queue.offer(task)) {
                    this.removeCondition.await();
                    continue;
                }
                return;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBlocking(Runnable task, long timeout, TimeUnit unit) throws RejectedExecutionException, InterruptedException {
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        long now = System.currentTimeMillis();
        long deadline = now + unit.toMillis(timeout);
        if (deadline < 0L) {
            this.executeBlocking(task);
            return;
        }
        while (true) {
            this.lock.lock();
            try {
                if (!this.running) {
                    this.running = true;
                    boolean ok = false;
                    try {
                        this.parent.execute(this.runner);
                        ok = true;
                    }
                    finally {
                        if (!ok) {
                            this.running = false;
                        }
                    }
                }
                if (!this.queue.offer(task)) {
                    long remaining = deadline - now;
                    if (remaining <= 0L) {
                        throw new ExecutionTimedOutException();
                    }
                    this.removeCondition.await(remaining, TimeUnit.MILLISECONDS);
                    now = System.currentTimeMillis();
                    continue;
                }
                return;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeNonBlocking(Runnable task) throws RejectedExecutionException {
        Executor executor;
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        this.lock.lock();
        try {
            if (!this.running) {
                this.running = true;
                boolean ok = false;
                try {
                    this.parent.execute(this.runner);
                    ok = true;
                }
                finally {
                    if (!ok) {
                        this.running = false;
                    }
                }
            }
            if (this.queue.offer(task)) {
                return;
            }
            executor = this.handoffExecutor;
        }
        finally {
            this.lock.unlock();
        }
        if (executor != null) {
            executor.execute(task);
        }
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    @Override
    public void shutdown() {
        throw new SecurityException("shutdown() not allowed on container-managed executor");
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new SecurityException("shutdownNow() not allowed on container-managed executor");
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Runnable task;
                OrderedExecutor.this.lock.lock();
                try {
                    task = (Runnable)OrderedExecutor.this.queue.poll();
                    OrderedExecutor.this.removeCondition.signal();
                    if (task == null) {
                        OrderedExecutor.this.running = false;
                        return;
                    }
                }
                finally {
                    OrderedExecutor.this.lock.unlock();
                }
                try {
                    task.run();
                }
                catch (Throwable throwable) {
                }
            }
        }
    }
}

