/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;

public abstract class AbstractXMLDataSourceRuntimeHandler<T>
extends AbstractRuntimeOnlyHandler {
    protected static final String CONNECTION_PROPERTIES = "connection-properties";
    protected static final String XA_DATASOURCE_PROPERTIES = "xa-datasource-properties";
    protected static final String DATA_SOURCE = "data-source";
    protected static final String XA_DATA_SOURCE = "xa-data-source";
    private final Map<PathAddress, T> dataSourceConfigs = Collections.synchronizedMap(new HashMap());

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String opName = operation.require("operation").asString();
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        T dataSource = this.getDataSourceConfig(address);
        if (!"read-attribute".equals(opName)) {
            throw AbstractXMLDataSourceRuntimeHandler.unknownOperation(opName);
        }
        String attributeName = operation.require("name").asString();
        this.executeReadAttribute(attributeName, context, dataSource, address);
        context.stepCompleted();
    }

    public void registerDataSource(PathAddress address, T dataSource) {
        this.dataSourceConfigs.put(address, dataSource);
    }

    public void unregisterDataSource(PathAddress address) {
        this.dataSourceConfigs.remove(address);
    }

    protected abstract void executeReadAttribute(String var1, OperationContext var2, T var3, PathAddress var4);

    private static IllegalStateException unknownOperation(String opName) {
        throw ConnectorLogger.ROOT_LOGGER.unknownOperation(opName);
    }

    private T getDataSourceConfig(PathAddress operationAddress) throws OperationFailedException {
        ArrayList<PathElement> relativeAddress = new ArrayList<PathElement>();
        for (int i = operationAddress.size() - 1; i >= 0; --i) {
            PathElement pe = operationAddress.getElement(i);
            relativeAddress.add(0, pe);
            if ("deployment".equals(pe.getKey())) break;
        }
        PathAddress pa = PathAddress.pathAddress(relativeAddress);
        T config = operationAddress.getLastElement().getKey().equals(CONNECTION_PROPERTIES) || operationAddress.getLastElement().getKey().equals(XA_DATASOURCE_PROPERTIES) ? this.dataSourceConfigs.get(pa.subAddress(0, pa.size() - 1)) : this.dataSourceConfigs.get(pa);
        if (config == null) {
            String exceptionMessage = ConnectorLogger.ROOT_LOGGER.noDataSourceRegisteredForAddress(operationAddress);
            throw new OperationFailedException(exceptionMessage);
        }
        return config;
    }

    protected void setLongIfNotNull(OperationContext context, Long value) {
        if (value != null) {
            context.getResult().set(value.longValue());
        }
    }

    protected void setIntIfNotNull(OperationContext context, Integer value) {
        if (value != null) {
            context.getResult().set(value.intValue());
        }
    }

    protected void setBooleanIfNotNull(OperationContext context, Boolean value) {
        if (value != null) {
            context.getResult().set(value.booleanValue());
        }
    }

    protected void setStringIfNotNull(OperationContext context, String value) {
        if (value != null) {
            context.getResult().set(value);
        }
    }
}

