/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.plan;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.jboss.as.controller.BlockingTimeout;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.plan.AbstractServerGroupRolloutTask;
import org.jboss.as.domain.controller.plan.ServerTaskExecutor;
import org.jboss.as.domain.controller.plan.ServerUpdatePolicy;
import org.jboss.as.domain.controller.plan.ServerUpdateTask;

class RollingServerGroupUpdateTask
extends AbstractServerGroupRolloutTask
implements Runnable {
    public RollingServerGroupUpdateTask(List<ServerUpdateTask> tasks, ServerUpdatePolicy updatePolicy, ServerTaskExecutor executor, Subject subject, BlockingTimeout blockingTimeout) {
        super(tasks, updatePolicy, executor, subject, blockingTimeout);
    }

    @Override
    public void execute() {
        boolean interrupted = false;
        ServerTaskExecutor.ServerOperationListener listener = new ServerTaskExecutor.ServerOperationListener();
        for (ServerUpdateTask task : this.tasks) {
            ServerIdentity identity = task.getServerIdentity();
            if (interrupted || !this.updatePolicy.canUpdateServer(identity)) {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Skipping server update task for %s", identity);
                continue;
            }
            long timeout = this.executor.executeTask((TransactionalProtocolClient.TransactionalOperationListener<ServerTaskExecutor.ServerOperation>)listener, task);
            if (timeout <= -1L) continue;
            try {
                TransactionalProtocolClient.PreparedOperation prepared = listener.retrievePreparedOperation(timeout, TimeUnit.MILLISECONDS);
                if (prepared != null) {
                    this.recordPreparedOperation(identity, (TransactionalProtocolClient.PreparedOperation<ServerTaskExecutor.ServerOperation>)prepared);
                    continue;
                }
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.timedOutAwaitingPreparedResponse(this.getClass().getSimpleName(), timeout, Collections.singleton(identity));
                this.executor.cancelTask(identity);
                this.handlePreparePhaseTimeout(identity, task, timeout);
            }
            catch (InterruptedException e) {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.interruptedAwaitingPreparedResponse(this.getClass().getSimpleName(), Collections.singleton(identity));
                this.executor.cancelTask(identity);
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

