/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.io.Serializable;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.backend.spi.DeleteByQueryLuceneWork;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.indexmanager.LuceneWorkIdTransformer;

public class LuceneWorkTransformationVisitor
implements IndexWorkVisitor<KeyTransformationHandler, LuceneWork> {
    static final LuceneWorkTransformationVisitor INSTANCE = new LuceneWorkTransformationVisitor();
    private static final LuceneWorkIdTransformer<AddLuceneWork> addDuplicator = new AddWorkDuplicator();
    private static final LuceneWorkIdTransformer<DeleteLuceneWork> deleteDuplicator = new DeleteWorkDuplicator();
    private static final LuceneWorkIdTransformer<UpdateLuceneWork> updateDuplicator = new UpdateWorkDuplicator();
    private static final LuceneWorkIdTransformer<LuceneWork> returnSameDuplicator = new NotReallyDuplicator();

    private LuceneWorkTransformationVisitor() {
    }

    public LuceneWork visitAddWork(AddLuceneWork addLuceneWork, KeyTransformationHandler keyTransformationHandler) {
        return addDuplicator.cloneOverridingIdString(addLuceneWork, keyTransformationHandler);
    }

    public LuceneWork visitDeleteWork(DeleteLuceneWork deleteLuceneWork, KeyTransformationHandler keyTransformationHandler) {
        return deleteDuplicator.cloneOverridingIdString(deleteLuceneWork, keyTransformationHandler);
    }

    public LuceneWork visitUpdateWork(UpdateLuceneWork updateLuceneWork, KeyTransformationHandler keyTransformationHandler) {
        return updateDuplicator.cloneOverridingIdString(updateLuceneWork, keyTransformationHandler);
    }

    public LuceneWork visitOptimizeWork(OptimizeLuceneWork optimizeLuceneWork, KeyTransformationHandler keyTransformationHandler) {
        return returnSameDuplicator.cloneOverridingIdString((LuceneWork)optimizeLuceneWork, keyTransformationHandler);
    }

    public LuceneWork visitFlushWork(FlushLuceneWork flushLuceneWork, KeyTransformationHandler keyTransformationHandler) {
        return returnSameDuplicator.cloneOverridingIdString((LuceneWork)flushLuceneWork, keyTransformationHandler);
    }

    public LuceneWork visitPurgeAllWork(PurgeAllLuceneWork purgeAllLuceneWork, KeyTransformationHandler keyTransformationHandler) {
        return returnSameDuplicator.cloneOverridingIdString((LuceneWork)purgeAllLuceneWork, keyTransformationHandler);
    }

    public LuceneWork visitDeleteByQueryWork(DeleteByQueryLuceneWork work, KeyTransformationHandler p) {
        throw new UnsupportedOperationException("delete-by-query is not supported");
    }

    private static class NotReallyDuplicator
    implements LuceneWorkIdTransformer<LuceneWork> {
        private NotReallyDuplicator() {
        }

        @Override
        public LuceneWork cloneOverridingIdString(LuceneWork lw, KeyTransformationHandler keyTransformationHandler) {
            return lw;
        }
    }

    private static class DeleteWorkDuplicator
    implements LuceneWorkIdTransformer<DeleteLuceneWork> {
        private DeleteWorkDuplicator() {
        }

        @Override
        public DeleteLuceneWork cloneOverridingIdString(DeleteLuceneWork lw, KeyTransformationHandler keyTransformationHandler) {
            Serializable id = lw.getId();
            if (id == null) {
                String idInString = lw.getIdInString();
                return new DeleteLuceneWork((Serializable)((Object)idInString), idInString, lw.getEntityClass());
            }
            return lw;
        }
    }

    private static class UpdateWorkDuplicator
    implements LuceneWorkIdTransformer<UpdateLuceneWork> {
        private UpdateWorkDuplicator() {
        }

        @Override
        public UpdateLuceneWork cloneOverridingIdString(UpdateLuceneWork lw, KeyTransformationHandler keyTransformationHandler) {
            Serializable id = lw.getId();
            if (id == null) {
                String idInString = lw.getIdInString();
                return new UpdateLuceneWork((Serializable)((Object)idInString), idInString, lw.getEntityClass(), lw.getDocument(), lw.getFieldToAnalyzerMap());
            }
            return lw;
        }
    }

    private static class AddWorkDuplicator
    implements LuceneWorkIdTransformer<AddLuceneWork> {
        private AddWorkDuplicator() {
        }

        @Override
        public AddLuceneWork cloneOverridingIdString(AddLuceneWork lw, KeyTransformationHandler keyTransformationHandler) {
            Serializable id = lw.getId();
            if (id == null) {
                String idInString = lw.getIdInString();
                return new AddLuceneWork((Serializable)((Object)idInString), idInString, lw.getEntityClass(), lw.getDocument(), lw.getFieldToAnalyzerMap());
            }
            return lw;
        }
    }
}

