/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.patching.DirectoryStructure;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.installation.InstalledImage;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.Identity;
import org.jboss.as.patching.metadata.LayerType;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchElement;
import org.jboss.as.patching.metadata.PatchElementProvider;
import org.jboss.as.patching.metadata.PatchMetadataResolver;
import org.jboss.as.patching.metadata.PatchXml;
import org.jboss.as.patching.metadata.RollbackPatch;
import org.jboss.as.patching.metadata.UpgradeCondition;
import org.jboss.as.patching.runner.ContentItemFilter;
import org.jboss.as.patching.runner.IdentityApplyCallback;
import org.jboss.as.patching.runner.IdentityPatchContext;
import org.jboss.as.patching.runner.IdentityRollbackCallback;
import org.jboss.as.patching.runner.Location;
import org.jboss.as.patching.runner.PatchContentLoader;
import org.jboss.as.patching.runner.PatchContentProvider;
import org.jboss.as.patching.runner.PatchingTask;
import org.jboss.as.patching.runner.PatchingTaskContext;
import org.jboss.as.patching.runner.PatchingTaskDescription;
import org.jboss.as.patching.runner.PatchingTasks;
import org.jboss.as.patching.runner.SecurityActions;
import org.jboss.as.patching.tool.ContentVerificationPolicy;
import org.jboss.as.patching.tool.PatchingHistory;
import org.jboss.as.patching.tool.PatchingResult;
import org.jboss.as.patching.validation.PatchHistoryValidations;

class IdentityPatchRunner
implements InstallationManager.ModificationCompletionCallback {
    private static final String DIRECTORY_SUFFIX = "jboss-as-patch-";
    private static final File TEMP_DIR = new File(SecurityActions.getSystemProperty("java.io.tmpdir"));
    private final InstalledImage installedImage;

    IdentityPatchRunner(InstalledImage installedImage) {
        this.installedImage = installedImage;
    }

    /*
     * Loose catch block
     */
    public PatchingResult applyPatch(PatchMetadataResolver patchResolver, PatchContentProvider contentProvider, ContentVerificationPolicy contentPolicy, InstallationManager.InstallationModification modification) throws PatchingException {
        try {
            Patch patch = patchResolver.resolvePatch(modification.getName(), modification.getVersion());
            if (patch == null) {
                throw PatchLogger.ROOT_LOGGER.failedToResolvePatch(modification.getName(), modification.getVersion());
            }
            String patchId = patch.getPatchId();
            Identity identity = patch.getIdentity();
            String appliesTo = identity.getVersion();
            if (!appliesTo.equals(modification.getVersion())) {
                throw PatchLogger.ROOT_LOGGER.doesNotApply(appliesTo, modification.getVersion());
            }
            if (modification.isApplied(patchId)) {
                throw PatchLogger.ROOT_LOGGER.alreadyApplied(patchId);
            }
            IdentityPatchRunner.checkUpgradeConditions(identity, modification);
            File backup = this.installedImage.getPatchHistoryDir(patchId);
            IdentityPatchContext context = new IdentityPatchContext(backup, contentProvider, contentPolicy, modification, PatchingTaskContext.Mode.APPLY, this.installedImage);
            try {
                PatchingResult patchingResult = this.applyPatch(patchId, patch, context);
                return patchingResult;
            }
            catch (Exception e) {
                PatchLogger.ROOT_LOGGER.debugf(e, "failed to apply patch %s", patchId);
                throw IdentityPatchRunner.rethrowException(e);
            }
            finally {
                context.cleanup();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            contentProvider.cleanup();
        }
    }

    private PatchingResult applyPatch(String patchId, Patch patch, IdentityPatchContext context) throws PatchingException, IOException, XMLStreamException {
        List<String> invalidation;
        Identity identity = patch.getIdentity();
        Patch.PatchType patchType = identity.getPatchType();
        InstallationManager.InstallationModification modification = context.getModification();
        if (patchType == Patch.PatchType.ONE_OFF) {
            invalidation = Collections.emptyList();
        } else {
            invalidation = new ArrayList<String>(modification.getPatchIDs());
            if (!invalidation.isEmpty()) {
                try {
                    PatchHistoryValidations.validateRollbackState(invalidation.get(invalidation.size() - 1), modification.getUnmodifiedInstallationState());
                }
                catch (PatchingException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new PatchingException(e);
                }
            }
        }
        for (String rollback : invalidation) {
            this.rollback(rollback, context);
        }
        modification.addInstalledPatch(patchId);
        for (PatchElement element : patch.getElements()) {
            IdentityPatchContext.PatchEntry target = context.resolveForElement(element);
            PatchElementProvider provider = element.getProvider();
            Patch.PatchType elementPatchType = provider.getPatchType();
            String elementPatchId = element.getId();
            if (target.isApplied(elementPatchId)) {
                throw PatchLogger.ROOT_LOGGER.alreadyApplied(elementPatchId);
            }
            IdentityPatchRunner.checkUpgradeConditions(provider, target);
            PatchingTasks.apply(elementPatchId, element.getModifications(), target.getDefinitions());
            target.apply(elementPatchId, elementPatchType);
        }
        IdentityPatchContext.PatchEntry identityEntry = context.getIdentityEntry();
        PatchingTasks.apply(patchId, patch.getModifications(), identityEntry.getDefinitions());
        identityEntry.apply(patchId, patchType);
        if (patchType == Patch.PatchType.CUMULATIVE) {
            this.portForward(patch, context);
        }
        if (patchType == Patch.PatchType.CUMULATIVE) {
            Identity.IdentityUpgrade upgrade = identity.forType(Patch.PatchType.CUMULATIVE, Identity.IdentityUpgrade.class);
            identityEntry.setResultingVersion(upgrade.getResultingVersion());
        }
        IdentityApplyCallback callback = new IdentityApplyCallback(patch, identityEntry.getDirectoryStructure());
        try {
            return IdentityPatchRunner.executeTasks(context, callback);
        }
        catch (Exception e) {
            context.cancel(callback);
            throw IdentityPatchRunner.rethrowException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PatchingResult rollbackPatch(String patchId, ContentVerificationPolicy contentPolicy, boolean rollbackTo, boolean resetConfiguration, InstallationManager.InstallationModification modification) throws PatchingException {
        if ("base".equals(patchId)) {
            throw PatchLogger.ROOT_LOGGER.cannotRollbackPatch(patchId);
        }
        try {
            PatchHistoryValidations.validateRollbackState(patchId, modification.getUnmodifiedInstallationState());
        }
        catch (PatchingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PatchingException(e);
        }
        ArrayList<String> patches = new ArrayList<String>();
        List<String> oneOffs = modification.getPatchIDs();
        int index = oneOffs.indexOf(patchId);
        if (index == -1) {
            if (!patchId.equals(modification.getCumulativePatchID())) throw PatchLogger.ROOT_LOGGER.cannotRollbackPatch(patchId);
            patches.addAll(oneOffs);
            patches.add(modification.getCumulativePatchID());
        } else if (index == 0) {
            patches.add(patchId);
        } else {
            if (!rollbackTo) throw PatchLogger.ROOT_LOGGER.cannotRollbackPatch(patchId);
            for (int i = 0; i <= index; ++i) {
                patches.add(oneOffs.get(i));
            }
        }
        File historyDir = this.installedImage.getPatchHistoryDir(patchId);
        IdentityPatchRunner.assertExists(historyDir);
        File rollbackXml = new File(historyDir, "rollback.xml");
        IdentityPatchRunner.assertExists(rollbackXml);
        File workDir = IdentityPatchRunner.createTempDir();
        PatchContentProvider provider = PatchContentProvider.ROLLBACK_PROVIDER;
        IdentityPatchContext context = new IdentityPatchContext(workDir, provider, contentPolicy, modification, PatchingTaskContext.Mode.ROLLBACK, this.installedImage);
        try {
            for (String rollback : patches) {
                if ("base".equals(rollback)) continue;
                this.rollback(rollback, context);
                modification.removeInstalledPatch(rollback);
            }
            IdentityPatchContext.PatchEntry identity = context.getIdentityEntry();
            IdentityRollbackCallback callback = new IdentityRollbackCallback(patchId, patches, resetConfiguration, identity.getDirectoryStructure());
            try {
                PatchingResult patchingResult = IdentityPatchRunner.executeTasks(context, callback);
                return patchingResult;
            }
            catch (Exception e) {
                context.cancel(callback);
                PatchLogger.ROOT_LOGGER.debugf(e, "failed to rollback patch %s", patchId);
                throw IdentityPatchRunner.rethrowException(e);
            }
        }
        finally {
            if (workDir != null && !IoUtils.recursiveDelete(workDir)) {
                PatchLogger.ROOT_LOGGER.cannotDeleteFile(workDir.getAbsolutePath());
            }
            context.cleanup();
        }
    }

    public PatchingResult rollbackLast(ContentVerificationPolicy contentPolicy, boolean resetConfiguration, InstallationManager.InstallationModification modification) throws PatchingException {
        String patchId;
        List<String> oneOffs = modification.getPatchIDs();
        if (oneOffs.isEmpty()) {
            patchId = modification.getCumulativePatchID();
            if (patchId == null || "base".equals(patchId)) {
                throw PatchLogger.ROOT_LOGGER.noPatchesApplied();
            }
        } else {
            patchId = oneOffs.get(0);
        }
        return this.rollbackPatch(patchId, contentPolicy, false, resetConfiguration, modification);
    }

    @Override
    public void completed() {
    }

    @Override
    public void canceled() {
    }

    private void rollback(String patchID, IdentityPatchContext context) throws PatchingException {
        try {
            PatchingTaskContext.Mode mode = context.getMode();
            Patch originalPatch = IdentityPatchRunner.loadPatchInformation(patchID, this.installedImage);
            RollbackPatch rollbackPatch = IdentityPatchRunner.loadRollbackInformation(patchID, this.installedImage);
            Patch.PatchType patchType = rollbackPatch.getIdentity().getPatchType();
            InstalledIdentity history = rollbackPatch.getIdentityState();
            LinkedHashMap<String, PatchElement> originalLayers = new LinkedHashMap<String, PatchElement>();
            LinkedHashMap originalAddOns = new LinkedHashMap();
            for (PatchElement patchElement : originalPatch.getElements()) {
                LinkedHashMap<String, PatchElement> originals;
                PatchElementProvider provider = patchElement.getProvider();
                String layerName = provider.getName();
                LayerType layerType = provider.getLayerType();
                switch (layerType) {
                    case Layer: {
                        originals = originalLayers;
                        break;
                    }
                    case AddOn: {
                        originals = originalAddOns;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                if (!originals.containsKey(layerName)) {
                    originals.put(layerName, patchElement);
                    continue;
                }
                throw PatchLogger.ROOT_LOGGER.installationDuplicateLayer(layerType.toString(), layerName);
            }
            for (PatchElement patchElement : rollbackPatch.getElements()) {
                LinkedHashMap<String, PatchElement> originals;
                String elementPatchId = patchElement.getId();
                PatchElementProvider provider = patchElement.getProvider();
                String layerName = provider.getName();
                LayerType layerType = provider.getLayerType();
                switch (layerType) {
                    case Layer: {
                        originals = originalLayers;
                        break;
                    }
                    case AddOn: {
                        originals = originalAddOns;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                PatchElement original = (PatchElement)originals.remove(layerName);
                if (original == null) {
                    throw PatchLogger.ROOT_LOGGER.noSuchLayer(layerName);
                }
                IdentityPatchContext.PatchEntry entry = context.resolveForElement(patchElement);
                Map<Location, PatchingTasks.ContentTaskDefinition> modifications = entry.getDefinitions();
                PatchingTasks.rollback(elementPatchId, original.getModifications(), patchElement.getModifications(), modifications, ContentItemFilter.ALL_BUT_MISC, mode);
                entry.rollback(original.getId());
                Patch.PatchType elementPatchType = provider.getPatchType();
                PatchableTarget.TargetInfo info = layerType == LayerType.AddOn ? history.getAddOn(layerName).loadTargetInfo() : history.getLayer(layerName).loadTargetInfo();
                if (mode != PatchingTaskContext.Mode.ROLLBACK) continue;
                IdentityPatchRunner.restoreFromHistory(entry, elementPatchId, elementPatchType, info);
            }
            if (!originalLayers.isEmpty() || !originalAddOns.isEmpty()) {
                throw PatchLogger.ROOT_LOGGER.invalidRollbackInformation();
            }
            IdentityPatchContext.PatchEntry identity = context.getIdentityEntry();
            PatchingTasks.rollback(patchID, originalPatch.getModifications(), rollbackPatch.getModifications(), identity.getDefinitions(), ContentItemFilter.MISC_ONLY, mode);
            identity.rollback(patchID);
            if (mode == PatchingTaskContext.Mode.ROLLBACK) {
                PatchableTarget.TargetInfo identityHistory = history.getIdentity().loadTargetInfo();
                IdentityPatchRunner.restoreFromHistory(identity, rollbackPatch.getPatchId(), patchType, identityHistory);
            }
            if (patchType == Patch.PatchType.CUMULATIVE) {
                Identity.IdentityUpgrade upgrade = rollbackPatch.getIdentity().forType(Patch.PatchType.CUMULATIVE, Identity.IdentityUpgrade.class);
                identity.setResultingVersion(upgrade.getResultingVersion());
            }
        }
        catch (Exception e) {
            throw IdentityPatchRunner.rethrowException(e);
        }
    }

    static void restoreFromHistory(InstallationManager.MutablePatchingTarget target, String rollbackPatchId, Patch.PatchType patchType, PatchableTarget.TargetInfo history) throws PatchingException {
        if (patchType == Patch.PatchType.CUMULATIVE) {
            assert (history.getCumulativePatchID().equals(rollbackPatchId));
            target.apply(rollbackPatchId, patchType);
            ArrayList<String> oneOffs = new ArrayList<String>(history.getPatchIDs());
            Collections.reverse(oneOffs);
            for (String oneOff : oneOffs) {
                target.apply(oneOff, Patch.PatchType.ONE_OFF);
            }
        }
        IdentityPatchRunner.checkState(history, history);
    }

    static void checkState(PatchableTarget.TargetInfo o, PatchableTarget.TargetInfo n) {
        assert (n.getPatchIDs().equals(o.getPatchIDs()));
        assert (n.getCumulativePatchID().equals(o.getCumulativePatchID()));
    }

    void portForward(Patch patch, IdentityPatchContext context) throws PatchingException, IOException, XMLStreamException {
        assert (patch.getIdentity().getPatchType() == Patch.PatchType.CUMULATIVE);
        PatchingHistory history = context.getHistory();
        for (PatchElement element : patch.getElements()) {
            PatchElementProvider provider = element.getProvider();
            String name = provider.getName();
            boolean addOn = provider.isAddOn();
            IdentityPatchContext.PatchEntry target = context.resolveForElement(element);
            String cumulativePatchID = target.getCumulativePatchID();
            if ("base".equals(cumulativePatchID)) continue;
            boolean found = false;
            PatchingHistory.Iterator iterator = history.iterator();
            while (iterator.hasNextCP()) {
                PatchingHistory.Entry entry = iterator.nextCP();
                String patchId = addOn ? entry.getAddOnPatches().get(name) : entry.getLayerPatches().get(name);
                if (patchId == null || !patchId.equals(cumulativePatchID)) continue;
                Patch original = IdentityPatchRunner.loadPatchInformation(entry.getPatchId(), this.installedImage);
                for (PatchElement originalElement : original.getElements()) {
                    if (!name.equals(originalElement.getProvider().getName()) || addOn != originalElement.getProvider().isAddOn()) continue;
                    PatchingTasks.addMissingModifications(cumulativePatchID, originalElement.getModifications(), target.getDefinitions(), ContentItemFilter.ALL_BUT_MISC);
                }
                DirectoryStructure structure = target.getDirectoryStructure();
                File modulesRoot = structure.getModulePatchDirectory(patchId);
                File bundlesRoot = structure.getBundlesPatchDirectory(patchId);
                PatchContentLoader loader = PatchContentLoader.create(null, bundlesRoot, modulesRoot);
                context.recordContentLoader(patchId, loader);
                found = true;
                break;
            }
            if (found) continue;
            throw PatchLogger.ROOT_LOGGER.patchNotFoundInHistory(cumulativePatchID);
        }
    }

    static PatchingResult executeTasks(IdentityPatchContext context, IdentityPatchContext.FinalizeCallback callback) throws Exception {
        ArrayList<PreparedTask> tasks = new ArrayList<PreparedTask>();
        ArrayList<ContentItem> conflicts = new ArrayList<ContentItem>();
        IdentityPatchRunner.prepareTasks(context.getIdentityEntry(), context, tasks, conflicts);
        for (IdentityPatchContext.PatchEntry layer : context.getLayers()) {
            IdentityPatchRunner.prepareTasks(layer, context, tasks, conflicts);
        }
        for (IdentityPatchContext.PatchEntry addOn : context.getAddOns()) {
            IdentityPatchRunner.prepareTasks(addOn, context, tasks, conflicts);
        }
        if (!conflicts.isEmpty()) {
            throw PatchLogger.ROOT_LOGGER.conflictsDetected(conflicts);
        }
        for (PreparedTask task : tasks) {
            ContentItem item = task.getContentItem();
            if (item != null && context.isExcluded(item)) continue;
            task.execute();
        }
        return context.finalize(callback);
    }

    static void prepareTasks(IdentityPatchContext.PatchEntry entry, IdentityPatchContext context, List<PreparedTask> tasks, List<ContentItem> conflicts) throws PatchingException {
        for (PatchingTasks.ContentTaskDefinition definition : entry.getDefinitions().values()) {
            PatchingTask task = IdentityPatchRunner.createTask(definition, context, entry);
            if (!task.isRelevant(entry)) continue;
            try {
                ContentItem item;
                if (!(task.prepare(entry) && !definition.hasConflicts() || context.isIgnored(item = task.getContentItem()))) {
                    conflicts.add(item);
                }
                tasks.add(new PreparedTask(task, entry));
            }
            catch (IOException e) {
                throw new PatchingException(e);
            }
        }
    }

    static PatchingTask createTask(PatchingTasks.ContentTaskDefinition definition, PatchContentProvider provider, IdentityPatchContext.PatchEntry context) {
        PatchContentLoader contentLoader = provider.getLoader(definition.getTarget().getPatchId());
        PatchingTaskDescription description = PatchingTaskDescription.create(definition, contentLoader);
        return PatchingTask.Factory.create(description, context);
    }

    static Patch loadPatchInformation(String patchId, InstalledImage installedImage) throws PatchingException, IOException, XMLStreamException {
        File patchDir = installedImage.getPatchHistoryDir(patchId);
        File patchXml = new File(patchDir, "patch.xml");
        return PatchXml.parse(patchXml).resolvePatch(null, null);
    }

    static RollbackPatch loadRollbackInformation(String patchId, InstalledImage installedImage) throws PatchingException, IOException, XMLStreamException {
        File historyDir = installedImage.getPatchHistoryDir(patchId);
        File patchXml = new File(historyDir, "rollback.xml");
        return (RollbackPatch)PatchXml.parse(patchXml).resolvePatch(null, null);
    }

    static File createTempDir() throws PatchingException {
        return IdentityPatchRunner.createTempDir(TEMP_DIR);
    }

    static File createTempDir(File parent) throws PatchingException {
        File workDir = null;
        int count = 0;
        while (workDir == null || workDir.exists()) {
            workDir = new File(parent == null ? TEMP_DIR : parent, DIRECTORY_SUFFIX + ++count);
        }
        if (!workDir.mkdirs()) {
            throw new PatchingException(PatchLogger.ROOT_LOGGER.cannotCreateDirectory(workDir.getAbsolutePath()));
        }
        return workDir;
    }

    static PatchingException rethrowException(Exception e) {
        if (e instanceof PatchingException) {
            return (PatchingException)e;
        }
        return new PatchingException(e);
    }

    static void checkUpgradeConditions(UpgradeCondition condition, InstallationManager.MutablePatchingTarget target) throws PatchingException {
        for (String required : condition.getRequires()) {
            if (target.isApplied(required)) continue;
            throw PatchLogger.ROOT_LOGGER.requiresPatch(required);
        }
        for (String incompatible : condition.getIncompatibleWith()) {
            if (!target.isApplied(incompatible)) continue;
            throw PatchLogger.ROOT_LOGGER.incompatiblePatch(incompatible);
        }
    }

    static void assertExists(File file) throws PatchingException {
        if (!file.exists()) {
            throw new PatchingException(PatchLogger.ROOT_LOGGER.fileDoesNotExist(file.getAbsolutePath()));
        }
    }

    static class PreparedTask {
        private final PatchingTask task;
        private final IdentityPatchContext.PatchEntry entry;

        PreparedTask(PatchingTask task, IdentityPatchContext.PatchEntry entry) {
            this.task = task;
            this.entry = entry;
        }

        ContentItem getContentItem() {
            return this.task.getContentItem();
        }

        protected void execute() throws IOException {
            this.task.execute(this.entry);
        }
    }
}

