/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.util.Util;

public class RoundTrip
extends ReceiverAdapter {
    JChannel channel;
    String props;
    int num = 1000;
    int msg_size = 10;
    boolean server = false;
    final byte[] RSP_BUF = new byte[]{1};
    int num_responses = 0;
    final Object mutex = new Object();

    private void start(boolean server, int num, int msg_size, String props) throws Exception {
        this.server = server;
        this.num = num;
        this.msg_size = msg_size;
        this.props = props;
        this.channel = new JChannel(props);
        this.channel.setReceiver(this);
        this.channel.connect("rt");
        if (server) {
            System.out.println("server started (ctrl-c to kill)");
            while (true) {
                Util.sleep(60000L);
            }
        }
        this.channel.setDiscardOwnMessages(true);
        System.out.println("sending " + num + " requests");
        this.sendRequests();
        this.channel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(Message msg) {
        byte[] buf = msg.getRawBuffer();
        if (buf == null) {
            System.err.println("buffer was null !");
            return;
        }
        if (buf[msg.getOffset()] == 0) {
            if (!this.server) {
                return;
            }
            Message response = new Message(msg.getSrc(), null, null);
            response.setBuffer(this.RSP_BUF, 0, this.RSP_BUF.length);
            try {
                this.channel.send(response);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Object object = this.mutex;
            synchronized (object) {
                ++this.num_responses;
                this.mutex.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequests() {
        int i;
        byte[] buf = new byte[this.msg_size];
        int print = this.num / 10;
        int count = 0;
        this.num_responses = 0;
        for (i = 0; i < buf.length; ++i) {
            buf[i] = 0;
        }
        long start = System.currentTimeMillis();
        for (i = 0; i < this.num; ++i) {
            Message msg = new Message(null, null, null);
            msg.setBuffer(buf);
            try {
                this.channel.send(msg);
                Object object = this.mutex;
                synchronized (object) {
                    while (this.num_responses != count + 1) {
                        this.mutex.wait(1000L);
                    }
                    count = this.num_responses;
                    if (this.num_responses >= this.num) {
                        System.out.println("received all responses (" + this.num_responses + ")");
                        break;
                    }
                }
                if (this.num_responses % print != 0) continue;
                System.out.println("- received " + this.num_responses);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        long stop = System.currentTimeMillis();
        long total = stop - start;
        double requests_per_sec = (double)this.num / ((double)total / 1000.0);
        double ms_per_req = (double)total / (double)this.num;
        System.out.println("Took " + total + "ms for " + this.num + " requests: " + requests_per_sec + " requests/sec, " + ms_per_req + " ms/request");
    }

    public static void main(String[] args) throws Exception {
        boolean server = false;
        int num = 100;
        int msg_size = 10;
        String props = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-num")) {
                num = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-server")) {
                server = true;
                continue;
            }
            if (args[i].equals("-size")) {
                msg_size = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            RoundTrip.help();
            return;
        }
        new RoundTrip().start(server, num, msg_size, props);
    }

    private static void help() {
        System.out.println("RoundTrip [-server] [-num <number of messages>] [-size <size of each message (in bytes)>] [-props <properties>]");
    }
}

