/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.cli.handlers;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.infinispan.server.cli.handlers.CacheCommand;
import org.infinispan.server.cli.handlers.NoArgumentsCliCommandHandler;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.util.HelpFormatter;
import org.jboss.as.protocol.StreamUtils;
import org.wildfly.security.manager.WildFlySecurityManager;

public abstract class CliCommandHandler
extends CommandHandlerWithArguments {
    protected final CacheCommand cacheCommand;
    protected final ArgumentWithoutValue help;

    protected CliCommandHandler(CacheCommand cacheCommand) {
        this.cacheCommand = cacheCommand;
        this.help = new ArgumentWithoutValue((CommandHandlerWithArguments)this, "--help", "-h");
        this.help.setExclusive(true);
    }

    protected void printHelp(CommandContext ctx) throws CommandLineException {
        String filename = "help/" + this.cacheCommand.getName() + ".txt";
        InputStream helpInput = WildFlySecurityManager.getClassLoaderPrivileged(NoArgumentsCliCommandHandler.class).getResourceAsStream(filename);
        if (helpInput != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(helpInput));
            try {
                HelpFormatter.format((CommandContext)ctx, (BufferedReader)reader);
            }
            catch (IOException e) {
                throw new CommandFormatException("Failed to read " + filename + ": " + e.getLocalizedMessage());
            }
            finally {
                StreamUtils.safeClose((Closeable)reader);
            }
        } else {
            throw new CommandFormatException("Failed to locate command description " + filename);
        }
    }

    public final void handle(CommandContext ctx) throws CommandLineException {
        this.recognizeArguments(ctx);
        if (this.help.isPresent(ctx.getParsedCommandLine())) {
            this.printHelp(ctx);
        } else {
            this.cliHandle(ctx);
        }
    }

    protected abstract void cliHandle(CommandContext var1) throws CommandLineException;
}

