/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import org.jgroups.nio.Buffers;
import org.jgroups.util.Util;

public class WriteBuffers
extends Buffers {
    protected int position;
    protected int limit;

    public WriteBuffers() {
    }

    public WriteBuffers(int capacity) {
        super(capacity);
    }

    public WriteBuffers(ByteBuffer data) {
        super(data);
        if (data == null) {
            throw new IllegalArgumentException("buffer must not be null");
        }
        this.limit = 2;
    }

    public int position() {
        return this.position;
    }

    public int limit() {
        return this.limit;
    }

    @Override
    public boolean write(SocketChannel ch, ByteBuffer buf) throws Exception {
        if (this.spaceAvailable() || this.makeSpace()) {
            this.add(buf);
        }
        return this.write(ch);
    }

    @Override
    public boolean write(SocketChannel ch) throws Exception {
        int num_buffers_to_write = this.size();
        if (num_buffers_to_write == 0) {
            return true;
        }
        if (ch != null) {
            try {
                ch.write(this.bufs, this.position, num_buffers_to_write);
            }
            catch (ClosedChannelException closed_ex) {
                throw closed_ex;
            }
            catch (IOException | NotYetConnectedException exception) {
                // empty catch block
            }
        }
        return this.nullData();
    }

    @Override
    public int remaining() {
        int remaining = 0;
        for (int i = this.position; i < this.limit; ++i) {
            ByteBuffer buf = this.bufs[i];
            remaining += buf.remaining();
        }
        return remaining;
    }

    public int size() {
        return this.limit - this.position;
    }

    public String print() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i = this.position; i < this.limit; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(Util.print(this.bufs[i]));
        }
        sb.append(" (").append(this.size()).append(" elements, remaining=").append(this.remaining()).append(")");
        return sb.toString();
    }

    @Override
    public String toString() {
        return String.format("[%d bufs pos=%d lim=%d cap=%d rem=%d]", this.size(), this.position, this.limit, this.bufs.length, this.remaining());
    }

    protected boolean spaceAvailable() {
        return this.bufs.length - this.limit >= 2;
    }

    protected boolean makeSpace() {
        if (this.position == this.limit) {
            this.limit = 0;
            this.position = 0;
            return true;
        }
        if (this.position == 0) {
            return false;
        }
        int buffers_to_move = this.size();
        int dest_index = 0;
        int src_index = this.position;
        while (dest_index < buffers_to_move) {
            this.bufs[dest_index] = this.bufs[src_index];
            ++dest_index;
            ++src_index;
        }
        for (int i = buffers_to_move; i < this.limit; ++i) {
            this.bufs[i] = null;
        }
        this.position = 0;
        this.limit = buffers_to_move;
        return this.spaceAvailable();
    }

    protected void add(ByteBuffer buf) {
        if (buf == null) {
            return;
        }
        this.bufs[this.limit++] = WriteBuffers.makeLengthBuffer(buf);
        this.bufs[this.limit++] = buf;
    }

    protected boolean nullData() {
        while (this.position < this.limit) {
            ByteBuffer buf = this.bufs[this.position];
            if (buf.remaining() > 0) {
                return false;
            }
            this.bufs[this.position++] = null;
        }
        if (this.position >= this.bufs.length) {
            this.makeSpace();
        }
        return true;
    }

    protected static ByteBuffer makeLengthBuffer(ByteBuffer buf) {
        return (ByteBuffer)ByteBuffer.allocate(4).putInt(buf.remaining()).clear();
    }
}

