/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import java.util.function.Predicate;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.logging.JavaLog;
import org.infinispan.server.core.transport.ExtendedByteBufJava;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.hotrod.AbstractVersionedDecoder;
import org.infinispan.server.hotrod.CacheDecodeContext;
import org.infinispan.server.hotrod.CacheUnavailableException;
import org.infinispan.server.hotrod.Constants$;
import org.infinispan.server.hotrod.Decoder10$;
import org.infinispan.server.hotrod.Decoder2x$;
import org.infinispan.server.hotrod.DecoderRequirements;
import org.infinispan.server.hotrod.HotRodDecoderState;
import org.infinispan.server.hotrod.HotRodException;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodUnknownOperationException;
import org.infinispan.server.hotrod.InvalidMagicIdException;
import org.infinispan.server.hotrod.RequestParameters;
import org.infinispan.server.hotrod.RequestParsingException;
import org.infinispan.server.hotrod.UnknownVersionException;

public class HotRodDecoder
extends ByteToMessageDecoder {
    private static final JavaLog log = (JavaLog)LogFactory.getLog(HotRodDecoder.class, JavaLog.class);
    private final EmbeddedCacheManager cacheManager;
    private final NettyTransport transport;
    private final Predicate<? super String> ignoreCache;
    private final HotRodServer server;
    CacheDecodeContext decodeCtx;
    Throwable previousException;
    private HotRodDecoderState state = HotRodDecoderState.DECODE_HEADER;
    private boolean resetRequested = true;

    public HotRodDecoder(EmbeddedCacheManager cacheManager, NettyTransport transport, HotRodServer server, Predicate<? super String> ignoreCache) {
        this.cacheManager = cacheManager;
        this.transport = transport;
        this.ignoreCache = ignoreCache;
        this.server = server;
        this.decodeCtx = new CacheDecodeContext(server);
    }

    public NettyTransport getTransport() {
        return this.transport;
    }

    void resetNow() {
        this.decodeCtx = new CacheDecodeContext(this.server);
        this.decodeCtx.setHeader(new HotRodHeader());
        this.state = HotRodDecoderState.DECODE_HEADER;
        this.resetRequested = false;
    }

    protected void state(HotRodDecoderState newState, ByteBuf buf) {
        buf.markReaderIndex();
        this.state = newState;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        try {
            if (this.decodeCtx.isTrace()) {
                log.tracef("Decode using instance @%x", System.identityHashCode((Object)this));
            }
            if (this.resetRequested) {
                this.resetNow();
            }
            in.markReaderIndex();
            switch (this.state) {
                case DECODE_HEADER: {
                    if (!this.decodeHeader(in, out)) break;
                    this.state(HotRodDecoderState.DECODE_KEY, in);
                }
                case DECODE_KEY: {
                    if (!this.decodeKey(in, out)) break;
                    this.state(HotRodDecoderState.DECODE_PARAMETERS, in);
                }
                case DECODE_PARAMETERS: {
                    if (!this.decodeParameters(in, out)) break;
                    this.state(HotRodDecoderState.DECODE_VALUE, in);
                }
                case DECODE_VALUE: {
                    if (!this.decodeValue(in, out)) break;
                    this.state(HotRodDecoderState.DECODE_HEADER, in);
                    break;
                }
                case DECODE_HEADER_CUSTOM: {
                    this.readCustomHeader(in, out);
                    break;
                }
                case DECODE_KEY_CUSTOM: {
                    this.readCustomKey(in, out);
                    break;
                }
                case DECODE_VALUE_CUSTOM: {
                    this.readCustomValue(in, out);
                }
            }
        }
        catch (Throwable t) {
            this.previousException = t;
            this.resetRequested = true;
            ctx.pipeline().fireExceptionCaught((Throwable)new HotRodException(this.decodeCtx.createExceptionResponse(t), t));
        }
    }

    boolean decodeHeader(ByteBuf in, List<Object> out) throws Exception {
        boolean shouldContinue = this.readHeader(in);
        if (!shouldContinue) {
            return false;
        }
        HotRodHeader header = this.decodeCtx.getHeader();
        if (this.ignoreCache.test(header.cacheName())) {
            throw new CacheUnavailableException();
        }
        this.decodeCtx.obtainCache(this.cacheManager);
        HotRodOperation op = header.op();
        switch (op.getDecoderRequirements()) {
            case HEADER_CUSTOM: {
                this.state(HotRodDecoderState.DECODE_HEADER_CUSTOM, in);
                this.readCustomHeader(in, out);
                return false;
            }
            case HEADER: {
                out.add(this.decodeCtx);
                this.resetRequested = true;
                return false;
            }
        }
        return true;
    }

    boolean readHeader(ByteBuf buffer) throws Exception {
        AbstractVersionedDecoder decoder = this.decodeCtx.decoder();
        HotRodHeader header = this.decodeCtx.header();
        if (decoder == null) {
            if (buffer.readableBytes() < 1) {
                return false;
            }
            short magic = buffer.readUnsignedByte();
            if (magic != Constants$.MODULE$.MAGIC_REQ()) {
                if (this.previousException == null) {
                    throw new InvalidMagicIdException("Error reading magic byte or message id: " + magic);
                }
                log.tracef("Error happened previously, ignoring %d byte until we find the magic number again", (int)magic);
                return false;
            }
            this.previousException = null;
            long messageId = ExtendedByteBufJava.readMaybeVLong((ByteBuf)buffer);
            if (messageId == Integer.MIN_VALUE) {
                return false;
            }
            header.messageId_$eq(messageId);
            if (buffer.readableBytes() < 1) {
                buffer.resetReaderIndex();
                return false;
            }
            byte version = (byte)buffer.readUnsignedByte();
            header.version_$eq(version);
            if (Constants$.MODULE$.isVersion2x(version)) {
                decoder = Decoder2x$.MODULE$;
            } else if (Constants$.MODULE$.isVersion1x(version)) {
                decoder = Decoder10$.MODULE$;
            } else {
                throw new UnknownVersionException("Unknown version:" + version, version, messageId);
            }
            this.decodeCtx.setDecoder(decoder);
            buffer.markReaderIndex();
        }
        try {
            if (!decoder.readHeader(buffer, header.version(), header.messageId(), header)) {
                return false;
            }
            if (this.decodeCtx.isTrace()) {
                log.tracef("Decoded header %s", (Object)header);
            }
            return true;
        }
        catch (SecurityException | HotRodUnknownOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RequestParsingException("Unable to parse header", header.version(), header.messageId(), e);
        }
    }

    private void readCustomHeader(ByteBuf in, List<Object> out) {
        this.decodeCtx.decoder().customReadHeader(this.decodeCtx.header(), in, this.decodeCtx, out);
        if (!out.isEmpty()) {
            this.resetRequested = true;
        }
    }

    boolean decodeKey(ByteBuf in, List<Object> out) {
        HotRodOperation op = this.decodeCtx.getHeader().op();
        if (op.requiresKey()) {
            byte[] bytes = ExtendedByteBufJava.readMaybeRangedBytes((ByteBuf)in);
            if (bytes != null) {
                this.decodeCtx.key_$eq(bytes);
            } else {
                return false;
            }
        }
        switch (op.getDecoderRequirements()) {
            case KEY_CUSTOM: {
                this.state(HotRodDecoderState.DECODE_KEY_CUSTOM, in);
                this.readCustomKey(in, out);
                return false;
            }
            case KEY: {
                out.add(this.decodeCtx);
                this.resetRequested = true;
                return false;
            }
        }
        return true;
    }

    private void readCustomKey(ByteBuf in, List<Object> out) {
        this.decodeCtx.decoder().customReadKey(this.decodeCtx.header(), in, this.decodeCtx, out);
        if (!out.isEmpty()) {
            this.resetRequested = true;
        }
    }

    boolean decodeParameters(ByteBuf in, List<Object> out) {
        RequestParameters params = this.decodeCtx.decoder().readParameters(this.decodeCtx.header(), in);
        if (params != null) {
            this.decodeCtx.params_$eq(params);
            if (this.decodeCtx.header().op().getDecoderRequirements() == DecoderRequirements.PARAMETERS) {
                out.add(this.decodeCtx);
                this.resetRequested = true;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean decodeValue(ByteBuf in, List<Object> out) {
        HotRodOperation op = this.decodeCtx.header().op();
        if (op.requireValue()) {
            int valueLength = this.decodeCtx.params().valueLength();
            if (in.readableBytes() < valueLength) {
                return false;
            }
            byte[] bytes = new byte[valueLength];
            in.readBytes(bytes);
            this.decodeCtx.operationDecodeContext_$eq(bytes);
        }
        switch (op.getDecoderRequirements()) {
            case VALUE_CUSTOM: {
                this.state(HotRodDecoderState.DECODE_VALUE_CUSTOM, in);
                this.readCustomValue(in, out);
                return false;
            }
            case VALUE: {
                out.add(this.decodeCtx);
                this.resetRequested = true;
                return false;
            }
        }
        return true;
    }

    private void readCustomValue(ByteBuf in, List<Object> out) {
        this.decodeCtx.decoder().customReadValue(this.decodeCtx.header(), in, this.decodeCtx, out);
        if (!out.isEmpty()) {
            this.resetRequested = true;
        }
    }
}

