/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.version;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jboss.as.version.UsageMessages;

public final class Usage {
    private static final String NEW_LINE = String.format("%n", new Object[0]);
    private final List<List<String>> arguments = new ArrayList<List<String>>();
    private final List<String> instructions = new ArrayList<String>();

    public String getDefaultUsageHeadline(String executableBaseName) {
        boolean isWindows = Usage.getSystemProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
        String executableName = isWindows ? executableBaseName : executableBaseName + ".sh";
        return UsageMessages.MESSAGES.argUsage(executableName);
    }

    public void addArguments(String ... args) {
        ArrayList<String> tempArguments = new ArrayList<String>();
        for (String arg : args) {
            tempArguments.add(arg);
        }
        this.arguments.add(tempArguments);
    }

    public void addInstruction(String instruction) {
        this.instructions.add(instruction);
    }

    public String usage(String headline) {
        StringBuilder sb = new StringBuilder();
        sb.append(NEW_LINE).append(headline).append(NEW_LINE);
        for (int i = 0; i < this.arguments.size(); ++i) {
            sb.append(this.getCommand(i)).append(NEW_LINE);
        }
        return sb.toString();
    }

    private String getCommand(int i) {
        ArrayList<String> segmentedInstructions = new ArrayList<String>();
        Usage.segmentInstructions(this.instructions.get(i), segmentedInstructions);
        ArrayList<String> segmentedArguments = new ArrayList<String>();
        Usage.segmentArguments(this.arguments.get(i), segmentedArguments, 0);
        StringBuilder output = new StringBuilder(String.format("    %-35s %s", segmentedArguments.remove(0), segmentedInstructions.remove(0)));
        output.append(NEW_LINE);
        if (segmentedArguments.size() <= segmentedInstructions.size()) {
            int count = 0;
            for (String arg : segmentedArguments) {
                output.append(String.format("         %-30s %s", arg, segmentedInstructions.remove(count)));
                output.append(NEW_LINE);
                ++count;
            }
            for (String instruction : segmentedInstructions) {
                output.append(String.format("%-40s%s", " ", instruction));
                output.append(NEW_LINE);
            }
        } else {
            int count = 0;
            for (String instruction : segmentedInstructions) {
                output.append(String.format("         %-30s %s", segmentedArguments.remove(count), instruction));
                output.append(NEW_LINE);
                ++count;
            }
            for (String arg : segmentedArguments) {
                output.append(String.format("         %-30s", arg));
                output.append(NEW_LINE);
            }
        }
        output.append(NEW_LINE);
        return output.toString();
    }

    private static void segmentArguments(List<String> input, List<String> output, int depth) {
        int width;
        int n = width = depth == 0 ? 35 : 30;
        if (input.size() > 0) {
            StringBuilder argumentsString = new StringBuilder();
            int i = 0;
            while (i < input.size()) {
                if (input.get(0).length() > width) {
                    String tooLong = input.remove(0);
                    tooLong.substring(0, width - 5);
                    input.add("Command removed. Too long.");
                }
                if (input.size() == 1 && argumentsString.toString().length() + input.get(0).length() <= width) {
                    argumentsString.append(input.remove(0));
                    continue;
                }
                if (argumentsString.toString().length() + input.get(0).length() + 2 > width) break;
                argumentsString.append(input.remove(0) + ", ");
            }
            output.add(argumentsString.toString());
            Usage.segmentArguments(input, output, depth + 1);
        }
    }

    private static void segmentInstructions(String instructions, List<String> segments) {
        if (instructions.length() <= 40) {
            segments.add(instructions);
        } else {
            String testFragment = instructions.substring(0, 40);
            int lastSpace = testFragment.lastIndexOf(32);
            if (lastSpace < 0) {
                lastSpace = 39;
            }
            segments.add(instructions.substring(0, lastSpace + 1));
            Usage.segmentInstructions(instructions.substring(lastSpace + 1), segments);
        }
    }

    private static String getSystemProperty(final String key) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(key);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
    }
}

