/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.wildfly.clustering.marshalling.Externalizer;

public class MapEntryExternalizer<T extends Map.Entry<Object, Object>>
implements Externalizer<T> {
    private final Class<T> targetClass;
    private final BiFunction<Object, Object, T> factory;

    MapEntryExternalizer(Class targetClass, BiFunction<Object, Object, T> factory) {
        this.targetClass = targetClass;
        this.factory = factory;
    }

    public void writeObject(ObjectOutput output, T entry) throws IOException {
        output.writeObject(entry.getKey());
        output.writeObject(entry.getValue());
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return (T)((Map.Entry)this.factory.apply(input.readObject(), input.readObject()));
    }

    public Class<? extends T> getTargetClass() {
        return this.targetClass;
    }

    public static class SimpleImmutableEntryExternalizer
    extends MapEntryExternalizer<AbstractMap.SimpleImmutableEntry<Object, Object>> {
        public SimpleImmutableEntryExternalizer() {
            super(AbstractMap.SimpleImmutableEntry.class, AbstractMap.SimpleImmutableEntry::new);
        }
    }

    public static class SimpleEntryExternalizer
    extends MapEntryExternalizer<AbstractMap.SimpleEntry<Object, Object>> {
        public SimpleEntryExternalizer() {
            super(AbstractMap.SimpleEntry.class, AbstractMap.SimpleEntry::new);
        }
    }
}

