/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.lucene.LuceneProcessingChain;
import org.hibernate.hql.lucene.internal.builder.ClassBasedLucenePropertyHelper;
import org.hibernate.hql.lucene.spi.FieldBridgeProvider;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.StringBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.objectfilter.impl.BaseMatcher;
import org.infinispan.objectfilter.impl.ProtobufMatcher;
import org.infinispan.objectfilter.impl.hql.FilterParsingResult;
import org.infinispan.objectfilter.impl.syntax.BooleShannonExpansion;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.query.dsl.embedded.impl.JPAFilterAndConverter;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.dsl.embedded.impl.ResultProcessor;
import org.infinispan.query.dsl.embedded.impl.RowProcessor;
import org.infinispan.query.remote.impl.CompatibilityReflectionMatcher;
import org.infinispan.query.remote.impl.ProtobufIndexedFieldProvider;
import org.infinispan.query.remote.impl.QueryFacadeImpl;
import org.infinispan.query.remote.impl.SecurityActions;
import org.infinispan.query.remote.impl.filter.JPAProtobufFilterAndConverter;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.impl.logging.Log;

final class RemoteQueryEngine
extends QueryEngine {
    private static final Log log = (Log)LogFactory.getLog(RemoteQueryEngine.class, Log.class);
    private static final FieldBridge DOUBLE_FIELD_BRIDGE = new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)NumericFieldBridge.DOUBLE_FIELD_BRIDGE, QueryFacadeImpl.NULL_TOKEN_CODEC);
    private static final FieldBridge FLOAT_FIELD_BRIDGE = new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)NumericFieldBridge.FLOAT_FIELD_BRIDGE, QueryFacadeImpl.NULL_TOKEN_CODEC);
    private static final FieldBridge LONG_FIELD_BRIDGE = new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)NumericFieldBridge.LONG_FIELD_BRIDGE, QueryFacadeImpl.NULL_TOKEN_CODEC);
    private static final FieldBridge INT_FIELD_BRIDGE = new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)NumericFieldBridge.INT_FIELD_BRIDGE, QueryFacadeImpl.NULL_TOKEN_CODEC);
    private static final FieldBridge STRING_FIELD_BRIDGE = new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)new TwoWayString2FieldBridgeAdaptor((TwoWayStringBridge)StringBridge.INSTANCE), QueryFacadeImpl.NULL_TOKEN_CODEC);
    private final boolean isCompatMode;
    private final SerializationContext serCtx;

    public RemoteQueryEngine(AdvancedCache<?, ?> cache, boolean isIndexed, boolean isCompatMode, SerializationContext serCtx) {
        super(cache, isIndexed);
        this.isCompatMode = isCompatMode;
        this.serCtx = serCtx;
    }

    protected BaseMatcher getMatcher() {
        Class matcherImplClass = this.isCompatMode ? CompatibilityReflectionMatcher.class : ProtobufMatcher.class;
        return (BaseMatcher)SecurityActions.getCacheComponentRegistry(this.cache).getComponent(matcherImplClass);
    }

    protected ResultProcessor makeResultProcessor(ResultProcessor in) {
        return result -> {
            if (result instanceof ProtobufValueWrapper) {
                result = ((ProtobufValueWrapper)result).getBinary();
            }
            return in != null ? in.process(result) : result;
        };
    }

    protected RowProcessor makeProjectionProcessor(Class<?>[] projectedTypes) {
        if (this.isCompatMode) {
            return null;
        }
        int[] pos = new int[projectedTypes.length];
        int len = 0;
        for (int i = 0; i < projectedTypes.length; ++i) {
            if (projectedTypes[i] != Boolean.class) continue;
            pos[len++] = i;
        }
        if (len == 0) {
            return null;
        }
        int[] cols = len < pos.length ? Arrays.copyOf(pos, len) : pos;
        return row -> {
            for (int i : cols) {
                if (row[i] == null) continue;
                row[i] = (Integer)row[i] != 0;
            }
            return row;
        };
    }

    protected Query makeTypeQuery(Query query, String targetEntityName) {
        return this.isCompatMode ? query : new BooleanQuery.Builder().add(new BooleanClause((Query)new TermQuery(new Term("$type$", targetEntityName)), BooleanClause.Occur.MUST)).add(new BooleanClause(query, BooleanClause.Occur.MUST)).build();
    }

    protected JPAFilterAndConverter createFilter(String jpaQuery, Map<String, Object> namedParameters) {
        return this.isIndexed && !this.isCompatMode ? new JPAProtobufFilterAndConverter(jpaQuery, namedParameters) : new JPAFilterAndConverter(jpaQuery, namedParameters, this.isCompatMode ? CompatibilityReflectionMatcher.class : ProtobufMatcher.class);
    }

    protected BooleShannonExpansion.IndexedFieldProvider getIndexedFieldProvider(FilterParsingResult<?> parsingResult) {
        return this.isCompatMode ? super.getIndexedFieldProvider(parsingResult) : new ProtobufIndexedFieldProvider((Descriptor)parsingResult.getTargetEntityMetadata());
    }

    protected LuceneProcessingChain makeParsingProcessingChain(Map<String, Object> namedParameters) {
        LuceneProcessingChain processingChain;
        if (this.isCompatMode) {
            final EntityNamesResolver entityNamesResolver = new EntityNamesResolver(){

                public Class<?> getClassFromName(String entityName) {
                    return RemoteQueryEngine.this.serCtx.canMarshall(entityName) ? RemoteQueryEngine.this.serCtx.getMarshaller(entityName).getJavaClass() : null;
                }
            };
            FieldBridgeProvider fieldBridgeProvider = new FieldBridgeProvider(){
                private final ClassBasedLucenePropertyHelper propertyHelper;
                {
                    this.propertyHelper = new ClassBasedLucenePropertyHelper(RemoteQueryEngine.this.getSearchFactory(), entityNamesResolver);
                }

                public FieldBridge getFieldBridge(String type, String propertyPath) {
                    return this.propertyHelper.getFieldBridge(type, Arrays.asList(propertyPath.split("[.]")));
                }
            };
            processingChain = new LuceneProcessingChain.Builder(this.getSearchFactory(), entityNamesResolver).namedParameters(namedParameters).buildProcessingChainForClassBasedEntities(fieldBridgeProvider);
        } else {
            EntityNamesResolver entityNamesResolver = new EntityNamesResolver(){

                public Class<?> getClassFromName(String entityName) {
                    return RemoteQueryEngine.this.serCtx.canMarshall(entityName) ? ProtobufValueWrapper.class : null;
                }
            };
            FieldBridgeProvider fieldBridgeProvider = new FieldBridgeProvider(){

                public FieldBridge getFieldBridge(String type, String propertyPath) {
                    FieldDescriptor fd = RemoteQueryEngine.this.getFieldDescriptor(RemoteQueryEngine.this.serCtx, type, propertyPath);
                    switch (fd.getType()) {
                        case DOUBLE: {
                            return DOUBLE_FIELD_BRIDGE;
                        }
                        case FLOAT: {
                            return FLOAT_FIELD_BRIDGE;
                        }
                        case INT64: 
                        case UINT64: 
                        case FIXED64: 
                        case SFIXED64: 
                        case SINT64: {
                            return LONG_FIELD_BRIDGE;
                        }
                        case INT32: 
                        case FIXED32: 
                        case UINT32: 
                        case SFIXED32: 
                        case SINT32: 
                        case BOOL: 
                        case ENUM: {
                            return INT_FIELD_BRIDGE;
                        }
                        case STRING: 
                        case BYTES: 
                        case GROUP: 
                        case MESSAGE: {
                            return STRING_FIELD_BRIDGE;
                        }
                    }
                    return null;
                }
            };
            processingChain = new LuceneProcessingChain.Builder(this.getSearchFactory(), entityNamesResolver).namedParameters(namedParameters).buildProcessingChainForDynamicEntities(fieldBridgeProvider);
        }
        return processingChain;
    }

    private FieldDescriptor getFieldDescriptor(SerializationContext serCtx, String type, String attributePath) {
        Descriptor messageDescriptor = serCtx.getMessageDescriptor(type);
        FieldDescriptor fd = null;
        String[] split = attributePath.split("[.]");
        for (int i = 0; i < split.length; ++i) {
            String name = split[i];
            fd = messageDescriptor.findFieldByName(name);
            if (fd == null) {
                throw log.unknownField(name, messageDescriptor.getFullName());
            }
            IndexingMetadata indexingMetadata = (IndexingMetadata)messageDescriptor.getProcessedAnnotation("Indexed");
            if (indexingMetadata != null && !indexingMetadata.isFieldIndexed(fd.getNumber())) {
                throw log.fieldIsNotIndexed(name, messageDescriptor.getFullName());
            }
            if (i >= split.length - 1) continue;
            messageDescriptor = fd.getMessageType();
        }
        return fd;
    }
}

