/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.deployments;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.Services;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class LoggingConfigurationService
implements Service<LogContextConfiguration> {
    private final LogContextConfiguration logContextConfiguration;
    private final String configuration;

    public LoggingConfigurationService(LogContextConfiguration logContextConfiguration, String configuration) {
        this.logContextConfiguration = logContextConfiguration;
        this.configuration = configuration;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public LogContextConfiguration getValue() throws IllegalStateException, IllegalArgumentException {
        return this.logContextConfiguration;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    static ServiceName forDeployment(DeploymentUnit deployment) {
        return deployment.getServiceName().append(new String[]{"logging", "configuration"});
    }

    public static ServiceName forDeployment(PathAddress address) {
        String deploymentName = null;
        String subdeploymentName = null;
        for (PathElement element : address) {
            if ("deployment".equals(element.getKey())) {
                deploymentName = element.getValue();
                continue;
            }
            if (!"subdeployment".endsWith(element.getKey())) continue;
            subdeploymentName = element.getValue();
        }
        if (deploymentName == null) {
            throw LoggingLogger.ROOT_LOGGER.deploymentNameNotFound(address);
        }
        ServiceName result = subdeploymentName == null ? Services.deploymentUnitName(deploymentName) : Services.deploymentUnitName(deploymentName, subdeploymentName);
        return result.append(new String[]{"logging", "configuration"});
    }
}

