/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jboss.vfs.VFSLogger;
import org.jboss.vfs.VFSMessages;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.AbstractVirtualFileFilterWithAttributes;

public class SuffixMatchFilter
extends AbstractVirtualFileFilterWithAttributes {
    private Collection<String> suffixes;
    private boolean trace;

    public SuffixMatchFilter(String suffix) {
        this(suffix, null);
    }

    public SuffixMatchFilter(String suffix, VisitorAttributes attributes) {
        this(Collections.singleton(suffix), attributes);
    }

    public SuffixMatchFilter(Collection<String> suffixes) {
        this(suffixes, null);
    }

    public SuffixMatchFilter(Collection<String> suffixes, VisitorAttributes attributes) {
        super(attributes == null ? VisitorAttributes.DEFAULT : attributes);
        if (suffixes == null) {
            throw VFSMessages.MESSAGES.nullArgument("suffixes");
        }
        this.suffixes = new LinkedHashSet<String>();
        this.suffixes.addAll(suffixes);
    }

    @Override
    public boolean accepts(VirtualFile file) {
        String name = file.getName();
        boolean accepts = false;
        for (String suffix : this.suffixes) {
            if (!name.endsWith(suffix)) continue;
            accepts = true;
            break;
        }
        VFSLogger.ROOT_LOGGER.tracef("%s accepted: %s", file, accepts);
        return accepts;
    }
}

