/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.deployments;

import java.lang.reflect.Constructor;
import java.util.List;
import org.infinispan.server.endpoint.EndpointLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public abstract class AbstractServerExtensionProcessor<T>
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext ctx) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = ctx.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ServicesAttachment servicesAttachment = (ServicesAttachment)deploymentUnit.getAttachment(Attachments.SERVICES);
        if (module != null && servicesAttachment != null) {
            this.addServices(ctx, servicesAttachment, module);
        }
    }

    private void addServices(DeploymentPhaseContext ctx, ServicesAttachment servicesAttachment, Module module) {
        Class<T> serviceClass = this.getServiceClass();
        List services = servicesAttachment.getServiceImplementations(serviceClass.getName());
        ModuleClassLoader classLoader = module.getClassLoader();
        for (String serviceName : services) {
            try {
                Class<T> clazz = classLoader.loadClass(serviceName).asSubclass(serviceClass);
                Constructor<T> ctor = clazz.getConstructor(new Class[0]);
                T instance = ctor.newInstance(new Object[0]);
                this.installService(ctx, serviceName, instance);
            }
            catch (Exception e) {
                EndpointLogger.ROOT_LOGGER.cannotInstantiateClass(serviceName, e);
            }
        }
    }

    public abstract Class<T> getServiceClass();

    public abstract void installService(DeploymentPhaseContext var1, String var2, T var3);

    public void undeploy(DeploymentUnit context) {
    }
}

