/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.TopicConnection;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.JmsConnectionFactory;
import org.jboss.resource.adapter.jms.JmsConnectionManager;
import org.jboss.resource.adapter.jms.JmsSessionFactoryImpl;

public class JmsConnectionFactoryImpl
implements JmsConnectionFactory,
Referenceable {
    private static final long serialVersionUID = -5135366013101194277L;
    private static final Logger log = Logger.getLogger(JmsConnectionFactoryImpl.class);
    private ManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private Reference reference;

    public JmsConnectionFactoryImpl(ManagedConnectionFactory mcf, ConnectionManager cm) {
        this.mcf = mcf;
        boolean trace = log.isTraceEnabled();
        if (cm == null) {
            this.cm = new JmsConnectionManager();
            if (trace) {
                log.trace((Object)"Created new connection manager");
            }
        } else {
            this.cm = cm;
        }
        if (trace) {
            log.trace((Object)("Using ManagedConnectionFactory=" + mcf + ", ConnectionManager=" + cm));
        }
    }

    public void setReference(Reference reference) {
        this.reference = reference;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Using Reference=" + reference));
        }
    }

    public Reference getReference() {
        return this.reference;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        JmsSessionFactoryImpl qc = new JmsSessionFactoryImpl(this.mcf, this.cm, 1);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created queue connection: " + qc));
        }
        return qc;
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        JmsSessionFactoryImpl s = new JmsSessionFactoryImpl(this.mcf, this.cm, 1);
        s.setUserName(userName);
        s.setPassword(password);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created queue connection: " + s));
        }
        return s;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        JmsSessionFactoryImpl tc = new JmsSessionFactoryImpl(this.mcf, this.cm, 2);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created topic connection: " + tc));
        }
        return tc;
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        JmsSessionFactoryImpl s = new JmsSessionFactoryImpl(this.mcf, this.cm, 2);
        s.setUserName(userName);
        s.setPassword(password);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created topic connection: " + s));
        }
        return s;
    }

    public Connection createConnection() throws JMSException {
        JmsSessionFactoryImpl c = new JmsSessionFactoryImpl(this.mcf, this.cm, 0);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created connection: " + c));
        }
        return c;
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        JmsSessionFactoryImpl s = new JmsSessionFactoryImpl(this.mcf, this.cm, 0);
        s.setUserName(userName);
        s.setPassword(password);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created connection: " + s));
        }
        return s;
    }
}

