/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.OpenListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.UndertowService;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;

public abstract class ListenerService<T>
implements Service<T> {
    protected static final OptionMap commonOptions = OptionMap.builder().set(Options.TCP_NODELAY, true).set(Options.REUSE_ADDRESSES, true).set(Options.BALANCING_TOKENS, 1).set(Options.BALANCING_CONNECTIONS, 2).getMap();
    protected final InjectedValue<XnioWorker> worker = new InjectedValue();
    protected final InjectedValue<SocketBinding> binding = new InjectedValue();
    protected final InjectedValue<SocketBinding> redirectSocket = new InjectedValue();
    protected final InjectedValue<Pool<ByteBuffer>> bufferPool = new InjectedValue();
    protected final InjectedValue<Server> serverService = new InjectedValue();
    private final List<HandlerWrapper> listenerHandlerWrappers = new ArrayList<HandlerWrapper>();
    private final String name;
    protected final OptionMap listenerOptions;
    protected final OptionMap socketOptions;
    protected volatile OpenListener openListener;

    protected ListenerService(String name, OptionMap listenerOptions, OptionMap socketOptions) {
        this.name = name;
        this.listenerOptions = listenerOptions;
        this.socketOptions = socketOptions;
    }

    public InjectedValue<XnioWorker> getWorker() {
        return this.worker;
    }

    public InjectedValue<SocketBinding> getBinding() {
        return this.binding;
    }

    public InjectedValue<SocketBinding> getRedirectSocket() {
        return this.redirectSocket;
    }

    public InjectedValue<Pool<ByteBuffer>> getBufferPool() {
        return this.bufferPool;
    }

    public InjectedValue<Server> getServerService() {
        return this.serverService;
    }

    protected UndertowService getUndertowService() {
        return ((Server)this.serverService.getValue()).getUndertowService();
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean isSecure();

    protected void registerBinding() {
        ((SocketBinding)this.binding.getValue()).getSocketBindings().getNamedRegistry().registerBinding((ManagedBinding)new ListenerBinding((SocketBinding)this.binding.getValue()));
    }

    protected void unregisterBinding() {
        SocketBinding binding = (SocketBinding)this.binding.getValue();
        binding.getSocketBindings().getNamedRegistry().unregisterBinding(binding.getName());
    }

    protected abstract void preStart(StartContext var1);

    public void start(StartContext context) throws StartException {
        this.preStart(context);
        ((Server)this.serverService.getValue()).registerListener(this);
        try {
            InetSocketAddress socketAddress = ((SocketBinding)this.binding.getValue()).getSocketAddress();
            this.openListener = this.createOpenListener();
            ChannelListener acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)this.openListener);
            HttpHandler handler = ((Server)this.serverService.getValue()).getRoot();
            for (HandlerWrapper wrapper : this.listenerHandlerWrappers) {
                handler = wrapper.wrap(handler);
            }
            this.openListener.setRootHandler(handler);
            this.startListening((XnioWorker)this.worker.getValue(), socketAddress, (ChannelListener<AcceptingChannel<StreamConnection>>)acceptListener);
            this.registerBinding();
        }
        catch (IOException e) {
            this.cleanFailedStart();
            throw new StartException("Could not start http listener", (Throwable)e);
        }
    }

    protected abstract void cleanFailedStart();

    public void stop(StopContext context) {
        ((Server)this.serverService.getValue()).unregisterListener(this);
        this.stopListening();
        this.unregisterBinding();
    }

    void addWrapperHandler(HandlerWrapper wrapper) {
        this.listenerHandlerWrappers.add(wrapper);
    }

    public OpenListener getOpenListener() {
        return this.openListener;
    }

    protected abstract OpenListener createOpenListener();

    abstract void startListening(XnioWorker var1, InetSocketAddress var2, ChannelListener<AcceptingChannel<StreamConnection>> var3) throws IOException;

    abstract void stopListening();

    protected abstract String getProtocol();

    private static class ListenerBinding
    implements ManagedBinding {
        private final SocketBinding binding;

        private ListenerBinding(SocketBinding binding) {
            this.binding = binding;
        }

        public String getSocketBindingName() {
            return this.binding.getName();
        }

        public InetSocketAddress getBindAddress() {
            return this.binding.getSocketAddress();
        }

        public void close() throws IOException {
        }
    }
}

