/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.CacheTopologyInfoImpl;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashFactory;
import org.infinispan.client.hotrod.impl.consistenthash.SegmentConsistentHash;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.ByteArrayEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.Immutables;

public final class TopologyInfo {
    private static final Log log = LogFactory.getLog(TopologyInfo.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private Collection<SocketAddress> servers = new ArrayList<SocketAddress>();
    private Map<byte[], ConsistentHash> consistentHashes = CollectionFactory.makeMap((Equivalence)ByteArrayEquivalence.INSTANCE, (Equivalence)AnyEquivalence.getInstance());
    private Map<byte[], Integer> segmentsByCache = CollectionFactory.makeMap((Equivalence)ByteArrayEquivalence.INSTANCE, (Equivalence)AnyEquivalence.getInstance());
    private Map<byte[], AtomicInteger> topologyIds = CollectionFactory.makeMap((Equivalence)ByteArrayEquivalence.INSTANCE, (Equivalence)AnyEquivalence.getInstance());
    private final ConsistentHashFactory hashFactory = new ConsistentHashFactory();

    public TopologyInfo(AtomicInteger topologyId, Collection<SocketAddress> servers, Configuration configuration) {
        this.topologyIds.put(new byte[0], topologyId);
        this.servers = servers;
        this.hashFactory.init(configuration);
    }

    private Map<SocketAddress, Set<Integer>> getSegmentsByServer(byte[] cacheName) {
        ConsistentHash consistentHash = this.consistentHashes.get(cacheName);
        if (consistentHash != null) {
            return consistentHash.getSegmentsByServer();
        }
        Optional<Integer> numSegments = Optional.ofNullable(this.segmentsByCache.get(cacheName));
        Optional<Set> segments = numSegments.map(n -> IntStream.range(0, n).boxed().collect(Collectors.toSet()));
        return Immutables.immutableMapWrap(this.servers.stream().collect(Collectors.toMap(Function.identity(), s -> segments.orElse(Collections.emptySet()))));
    }

    public Collection<SocketAddress> getServers() {
        return this.servers;
    }

    public void updateTopology(Map<SocketAddress, Set<Integer>> servers2Hash, int numKeyOwners, short hashFunctionVersion, int hashSpace, byte[] cacheName, AtomicInteger topologyId) {
        Object hash = this.hashFactory.newConsistentHash(hashFunctionVersion);
        if (hash == null) {
            log.noHasHFunctionConfigured(hashFunctionVersion);
        } else {
            hash.init(servers2Hash, numKeyOwners, hashSpace);
        }
        this.consistentHashes.put(cacheName, (ConsistentHash)hash);
        this.topologyIds.put(cacheName, topologyId);
    }

    public void updateTopology(SocketAddress[][] segmentOwners, int numSegments, short hashFunctionVersion, byte[] cacheName, AtomicInteger topologyId) {
        if (hashFunctionVersion > 0) {
            SegmentConsistentHash hash = (SegmentConsistentHash)this.hashFactory.newConsistentHash(hashFunctionVersion);
            if (hash == null) {
                log.noHasHFunctionConfigured(hashFunctionVersion);
            } else {
                hash.init(segmentOwners, numSegments);
            }
            this.consistentHashes.put(cacheName, hash);
        }
        this.segmentsByCache.put(cacheName, numSegments);
        this.topologyIds.put(cacheName, topologyId);
    }

    public Optional<SocketAddress> getHashAwareServer(Object key, byte[] cacheName) {
        Optional<SocketAddress> server = Optional.empty();
        if (this.isTopologyValid(cacheName)) {
            ConsistentHash consistentHash = this.consistentHashes.get(cacheName);
            if (consistentHash != null) {
                server = Optional.of(consistentHash.getServer(key));
                if (trace) {
                    log.tracef("Using consistent hash for determining the server: " + server, new Object[0]);
                }
            }
            return server;
        }
        return Optional.empty();
    }

    public boolean isTopologyValid(byte[] cacheName) {
        Integer id = this.topologyIds.get(cacheName).get();
        Boolean valid = id != -2;
        if (trace) {
            log.tracef("Is topology id (%s) valid? %b", id, valid);
        }
        return valid;
    }

    public void updateServers(Collection<SocketAddress> updatedServers) {
        this.servers = updatedServers;
    }

    public ConsistentHash getConsistentHash(byte[] cacheName) {
        return this.consistentHashes.get(cacheName);
    }

    public ConsistentHashFactory getConsistentHashFactory() {
        return this.hashFactory;
    }

    public AtomicInteger createTopologyId(byte[] cacheName, int topologyId) {
        AtomicInteger id = new AtomicInteger(topologyId);
        this.topologyIds.put(cacheName, id);
        return id;
    }

    public void setTopologyId(byte[] cacheName, int topologyId) {
        AtomicInteger id = this.topologyIds.get(cacheName);
        id.set(topologyId);
    }

    public void setAllTopologyIds(int newTopologyId) {
        for (AtomicInteger topologyId : this.topologyIds.values()) {
            topologyId.set(newTopologyId);
        }
    }

    public int getTopologyId(byte[] cacheName) {
        return this.topologyIds.get(cacheName).get();
    }

    public CacheTopologyInfo getCacheTopologyInfo(byte[] cacheName) {
        return new CacheTopologyInfoImpl(this.getSegmentsByServer(cacheName), this.segmentsByCache.get(cacheName), this.topologyIds.get(cacheName).get());
    }
}

