/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldMetadataCreationContext;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.engine.metadata.impl.BridgeDefinedField;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;

class FieldMetadataBuilderImpl
implements FieldMetadataBuilder {
    private final Set<String> sortableFields = new HashSet<String>();
    private final Set<BridgeDefinedField> fields = new HashSet<BridgeDefinedField>();
    private final DocumentFieldMetadata fieldMetadata;

    public FieldMetadataBuilderImpl(DocumentFieldMetadata fieldMetadata) {
        this.fieldMetadata = fieldMetadata;
    }

    @Override
    public FieldMetadataCreationContext field(String name, FieldType type) {
        return new FieldMetadataCreationContextImpl(name, type);
    }

    public Set<String> getSortableFields() {
        return this.sortableFields;
    }

    public Set<BridgeDefinedField> getFields() {
        return this.fields;
    }

    private class FieldMetadataCreationContextImpl
    implements FieldMetadataCreationContext {
        private final String fieldName;
        private DocumentFieldMetadata.Builder builder;

        public FieldMetadataCreationContextImpl(String name, FieldType type) {
            this.fieldName = name;
            FieldMetadataBuilderImpl.this.fields.add(new BridgeDefinedField(name, type, FieldMetadataBuilderImpl.this.fieldMetadata.getIndex()));
        }

        @Override
        public FieldMetadataCreationContext field(String name, FieldType type) {
            return FieldMetadataBuilderImpl.this.field(name, type);
        }

        @Override
        public FieldMetadataCreationContext sortable(boolean sortable) {
            FieldMetadataBuilderImpl.this.sortableFields.add(this.fieldName);
            return this;
        }
    }
}

