/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Unsupported;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@Experimental
@Unsupported
public class HashedTimingWheel
implements TimeScheduler,
Runnable {
    private final ThreadPoolExecutor pool;
    private Thread runner = null;
    private final Lock lock = new ReentrantLock();
    protected volatile boolean running;
    protected static final Log log = LogFactory.getLog(HashedTimingWheel.class);
    protected ThreadFactory timer_thread_factory = null;
    protected int wheel_size = 200;
    protected long tick_time = 50L;
    protected final long ROTATION_TIME;
    protected final List<MyTask>[] wheel;
    protected int wheel_position = 0;

    public HashedTimingWheel() {
        this.ROTATION_TIME = (long)this.wheel_size * this.tick_time;
        this.wheel = new List[this.wheel_size];
        this.pool = new ThreadPoolExecutor(4, 10, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(5000), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        this.init();
    }

    public HashedTimingWheel(ThreadFactory factory, int min_threads, int max_threads, long keep_alive_time, int max_queue_size, int wheel_size, long tick_time) {
        this.wheel_size = wheel_size;
        this.tick_time = tick_time;
        this.ROTATION_TIME = (long)wheel_size * tick_time;
        this.wheel = new List[this.wheel_size];
        this.timer_thread_factory = factory;
        this.pool = new ThreadPoolExecutor(min_threads, max_threads, keep_alive_time, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(max_queue_size), factory, new ThreadPoolExecutor.CallerRunsPolicy());
        this.init();
    }

    public HashedTimingWheel(int corePoolSize) {
        this.ROTATION_TIME = (long)this.wheel_size * this.tick_time;
        this.wheel = new List[this.wheel_size];
        this.pool = new ThreadPoolExecutor(corePoolSize, corePoolSize * 2, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(5000), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        this.init();
    }

    @Override
    public void setThreadFactory(ThreadFactory factory) {
        this.pool.setThreadFactory(factory);
    }

    @Override
    public int getMinThreads() {
        return this.pool.getCorePoolSize();
    }

    @Override
    public void setMinThreads(int size) {
        this.pool.setCorePoolSize(size);
    }

    @Override
    public int getMaxThreads() {
        return this.pool.getMaximumPoolSize();
    }

    @Override
    public void setMaxThreads(int size) {
        this.pool.setMaximumPoolSize(size);
    }

    @Override
    public long getKeepAliveTime() {
        return this.pool.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setKeepAliveTime(long time) {
        this.pool.setKeepAliveTime(time, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getCurrentThreads() {
        return this.pool.getPoolSize();
    }

    public int getQueueSize() {
        return this.pool.getQueue().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String dumpTimerTasks() {
        StringBuilder sb = new StringBuilder();
        this.lock.lock();
        try {
            for (List<MyTask> list : this.wheel) {
                if (list.isEmpty()) continue;
                sb.append(list).append("\n");
            }
        }
        finally {
            this.lock.unlock();
        }
        return sb.toString();
    }

    @Override
    public void execute(Runnable task) {
        this.schedule(task, 0L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<?> schedule(Runnable work, long delay, TimeUnit unit) {
        if (work == null) {
            throw new NullPointerException();
        }
        if (this.isShutdown() || !this.running) {
            return null;
        }
        MyTask retval = null;
        long time = TimeUnit.MILLISECONDS.convert(delay, unit);
        this.lock.lock();
        try {
            int num_ticks = (int)Math.max(1L, time % this.ROTATION_TIME / this.tick_time);
            int position = (this.wheel_position + num_ticks) % this.wheel_size;
            int rounds = (int)(time / this.ROTATION_TIME);
            List<MyTask> list = this.wheel[position];
            retval = new MyTask(work, rounds);
            list.add(retval);
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    @Override
    public Future<?> scheduleWithFixedDelay(Runnable task, long initial_delay, long delay, TimeUnit unit) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.isShutdown() || !this.running) {
            return null;
        }
        FixedIntervalTask wrapper = new FixedIntervalTask(task, delay);
        wrapper.doSchedule(initial_delay);
        return wrapper;
    }

    @Override
    public Future<?> scheduleAtFixedRate(Runnable task, long initial_delay, long delay, TimeUnit unit) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.isShutdown() || !this.running) {
            return null;
        }
        FixedRateTask wrapper = new FixedRateTask(task, delay);
        wrapper.doSchedule(initial_delay);
        return wrapper;
    }

    @Override
    public Future<?> scheduleWithDynamicInterval(TimeScheduler.Task task) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.isShutdown() || !this.running) {
            return null;
        }
        DynamicIntervalTask task_wrapper = new DynamicIntervalTask(task);
        task_wrapper.doSchedule();
        return task_wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int retval = 0;
        this.lock.lock();
        try {
            for (List<MyTask> list : this.wheel) {
                retval += list.size();
            }
            int n = retval;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void stop() {
        this.stopRunner();
        List<Runnable> remaining_tasks = this.pool.shutdownNow();
        for (Runnable task : remaining_tasks) {
            if (!(task instanceof Future)) continue;
            Future future = (Future)((Object)task);
            future.cancel(true);
        }
        this.pool.getQueue().clear();
        try {
            this.pool.awaitTermination(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean isShutdown() {
        return this.pool.isShutdown();
    }

    @Override
    public void run() {
        long base_time = System.currentTimeMillis();
        long cnt = 0L;
        while (this.running) {
            try {
                this._run();
                long next_time = base_time + ++cnt * this.tick_time;
                long sleep_time = Math.max(0L, next_time - System.currentTimeMillis());
                Util.sleep(sleep_time);
            }
            catch (Throwable t) {
                log.error(Util.getMessage("FailedExecutingTasksS"), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _run() {
        this.lock.lock();
        try {
            this.wheel_position = (this.wheel_position + 1) % this.wheel_size;
            List<MyTask> list = this.wheel[this.wheel_position];
            if (list.isEmpty()) {
                return;
            }
            Iterator<MyTask> it = list.iterator();
            while (it.hasNext()) {
                MyTask tmp = it.next();
                if (tmp.getAndDecrementRound() > 0) continue;
                try {
                    this.pool.execute(tmp);
                }
                catch (Throwable t) {
                    log.error(Util.getMessage("FailureSubmittingTaskToThreadPool"), t);
                }
                it.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void init() {
        for (int i = 0; i < this.wheel.length; ++i) {
            this.wheel[i] = new LinkedList<MyTask>();
        }
        this.startRunner();
    }

    protected void startRunner() {
        this.running = true;
        this.runner = this.timer_thread_factory != null ? this.timer_thread_factory.newThread(this, "Timer runner") : new Thread((Runnable)this, "Timer runner");
        this.runner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopRunner() {
        this.lock.lock();
        try {
            this.running = false;
            for (List<MyTask> list : this.wheel) {
                if (list.isEmpty()) continue;
                for (MyTask task : list) {
                    task.cancel(true);
                }
                list.clear();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private class DynamicIntervalTask<V>
    extends RecurringTask<V> {
        public DynamicIntervalTask(TimeScheduler.Task task) {
            super(task);
        }

        @Override
        protected long nextInterval() {
            if (this.task instanceof TimeScheduler.Task) {
                return ((TimeScheduler.Task)this.task).nextInterval();
            }
            return 0L;
        }
    }

    private class FixedRateTask<V>
    extends RecurringTask<V> {
        final long interval;
        final long first_execution;
        int num_executions;

        public FixedRateTask(Runnable task, long interval) {
            super(task);
            this.num_executions = 0;
            this.interval = interval;
            this.first_execution = System.currentTimeMillis();
        }

        @Override
        protected long nextInterval() {
            long target_time = this.first_execution + this.interval * (long)(++this.num_executions);
            return target_time - System.currentTimeMillis();
        }

        @Override
        protected boolean rescheduleOnZeroDelay() {
            return true;
        }
    }

    private class FixedIntervalTask<V>
    extends RecurringTask<V> {
        final long interval;

        public FixedIntervalTask(Runnable task, long interval) {
            super(task);
            this.interval = interval;
        }

        @Override
        protected long nextInterval() {
            return this.interval;
        }
    }

    private abstract class RecurringTask<V>
    implements Runnable,
    Future<V> {
        protected final Runnable task;
        protected volatile Future<?> future;
        protected volatile boolean cancelled = false;

        public RecurringTask(Runnable task) {
            this.task = task;
        }

        protected abstract long nextInterval();

        protected boolean rescheduleOnZeroDelay() {
            return false;
        }

        public void doSchedule() {
            long next_interval = this.nextInterval();
            if (next_interval <= 0L && !this.rescheduleOnZeroDelay()) {
                if (log.isTraceEnabled()) {
                    log.trace("task will not get rescheduled as interval is " + next_interval);
                }
                return;
            }
            this.future = HashedTimingWheel.this.schedule(this, next_interval, TimeUnit.MILLISECONDS);
            if (this.cancelled) {
                this.future.cancel(true);
            }
        }

        public void doSchedule(long next_interval) {
            this.future = HashedTimingWheel.this.schedule(this, next_interval, TimeUnit.MILLISECONDS);
            if (this.cancelled) {
                this.future.cancel(true);
            }
        }

        @Override
        public void run() {
            if (this.cancelled) {
                if (this.future != null) {
                    this.future.cancel(true);
                }
                return;
            }
            try {
                this.task.run();
            }
            catch (Throwable t) {
                log.error(Util.getMessage("FailedRunningTask") + this.task, t);
            }
            if (!this.cancelled) {
                this.doSchedule();
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean retval = !this.isDone();
            this.cancelled = true;
            if (this.future != null) {
                this.future.cancel(mayInterruptIfRunning);
            }
            return retval;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.cancelled || this.future == null || this.future.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName() + ": task=" + this.task + ", cancelled=" + this.isCancelled());
            return sb.toString();
        }
    }

    protected static class MyTask
    implements Future,
    Runnable {
        protected final Runnable task;
        protected volatile boolean cancelled = false;
        protected volatile boolean done = false;
        protected MyTask next;
        protected int round;

        public MyTask(Runnable task, int round) {
            this.task = task;
            this.round = round;
        }

        public int getRound() {
            return this.round;
        }

        public int getAndDecrementRound() {
            return this.round--;
        }

        public void setRound(int round) {
            this.round = round;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean retval = !this.isDone();
            this.cancelled = true;
            return retval;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.done || this.cancelled;
        }

        public Object get() throws InterruptedException, ExecutionException {
            return null;
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.isDone()) {
                return;
            }
            try {
                this.task.run();
            }
            catch (Throwable t) {
                log.error(Util.getMessage("FailedExecutingTask") + this.task, t);
            }
            finally {
                this.done = true;
            }
        }

        public String toString() {
            return this.task.toString();
        }
    }
}

