/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import org.hibernate.search.backend.BackendFactory;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.AsyncWorkProcessor;
import org.hibernate.search.backend.impl.lucene.LuceneBackendResources;
import org.hibernate.search.backend.impl.lucene.LuceneBackendTaskStreamer;
import org.hibernate.search.backend.impl.lucene.SyncWorkProcessor;
import org.hibernate.search.backend.impl.lucene.WorkProcessor;
import org.hibernate.search.backend.impl.lucene.WorkspaceFactory;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class WorkspaceHolder {
    private static final Log log = LoggerFactory.make();
    private volatile LuceneBackendResources resources;
    private boolean sync;
    private AbstractWorkspaceImpl workspaceOverride;
    private LuceneBackendTaskStreamer streamWorker;
    private WorkProcessor workProcessor;

    public void initialize(Properties props, WorkerBuildContext context, IndexManager indexManager) {
        this.sync = BackendFactory.isConfiguredAsSync(props);
        if (this.workspaceOverride == null) {
            this.workspaceOverride = WorkspaceFactory.createWorkspace((DirectoryBasedIndexManager)indexManager, context, props);
        }
        this.resources = new LuceneBackendResources(context, (DirectoryBasedIndexManager)indexManager, props, this.workspaceOverride);
        this.streamWorker = new LuceneBackendTaskStreamer(this.resources);
        String indexName = indexManager.getIndexName();
        if (this.sync) {
            SyncWorkProcessor batchSyncProcessor = new SyncWorkProcessor(this.resources, indexName);
            batchSyncProcessor.start();
            log.luceneBackendInitializedSynchronously(indexName);
            this.workProcessor = batchSyncProcessor;
        } else {
            this.workProcessor = new AsyncWorkProcessor(this.resources);
            log.luceneBackendInitializedAsynchronously(indexName);
        }
    }

    public void close() {
        this.workProcessor.shutdown();
        this.resources.shutdown();
    }

    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor) {
        if (singleOperation == null) {
            throw new IllegalArgumentException("singleOperation should not be null");
        }
        this.streamWorker.doWork(singleOperation, monitor);
    }

    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor) {
        if (workList == null) {
            throw new IllegalArgumentException("workList should not be null");
        }
        this.workProcessor.submit(workList, monitor);
    }

    public Lock getExclusiveWriteLock() {
        return this.resources.getExclusiveModificationLock();
    }

    public LuceneBackendResources getIndexResources() {
        return this.resources;
    }

    public void setCustomWorkspace(AbstractWorkspaceImpl workspace) {
        this.workspaceOverride = workspace;
    }

    public void indexMappingChanged() {
        this.resources = this.resources.onTheFlyRebuild();
        this.workProcessor.updateResources(this.resources);
    }

    public void closeIndexWriter() {
        LuceneBackendResources backendResources = this.resources;
        if (backendResources != null) {
            backendResources.getWorkspace().closeIndexWriter();
        }
    }
}

