/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.search.indexes.spi.AnalyzerExecutionStrategy;
import org.hibernate.search.indexes.spi.IndexManagerType;

public class ParseContext {
    private final Set<XClass> processedClasses = new HashSet<XClass>();
    private final Set<String> spatialNames = new TreeSet<String>();
    private final Set<String> unqualifiedCollectedCollectionRoles = new HashSet<String>();
    private IndexManagerType indexManagerType;
    private XClass currentClass;
    private int level = 0;
    private int maxLevel = Integer.MAX_VALUE;
    private boolean explicitDocumentId = false;
    private boolean includeEmbeddedObjectId = false;

    public IndexManagerType getIndexManagerType() {
        return this.indexManagerType;
    }

    void setIndexManagerType(IndexManagerType indexManagerType) {
        this.indexManagerType = indexManagerType;
    }

    boolean skipFieldBridges() {
        return this.indexManagerType == null;
    }

    boolean skipAnalyzers() {
        return this.indexManagerType == null;
    }

    boolean isAnalyzerRemote() {
        return this.indexManagerType != null && this.indexManagerType.getAnalyzerExecutionStrategy() == AnalyzerExecutionStrategy.REMOTE;
    }

    boolean hasBeenProcessed(XClass processedClass) {
        return this.processedClasses.contains(processedClass);
    }

    void processingClass(XClass processedClass) {
        this.processedClasses.add(processedClass);
    }

    void removeProcessedClass(XClass processedClass) {
        this.processedClasses.remove(processedClass);
    }

    boolean isSpatialNameUsed(String name) {
        return this.spatialNames.contains(name);
    }

    void markSpatialNameAsUsed(String name) {
        this.spatialNames.add(name);
    }

    public XClass getCurrentClass() {
        return this.currentClass;
    }

    public void setCurrentClass(XClass currentClass) {
        this.currentClass = currentClass;
    }

    boolean isMaxLevelReached() {
        return this.level > this.maxLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int newMaxLevel) {
        this.maxLevel = newMaxLevel;
    }

    public int getLevel() {
        return this.level;
    }

    public void incrementLevel() {
        ++this.level;
    }

    public void decrementLevel() {
        --this.level;
    }

    public boolean isExplicitDocumentId() {
        return this.explicitDocumentId;
    }

    public void setExplicitDocumentId(boolean explicitDocumentId) {
        this.explicitDocumentId = explicitDocumentId;
    }

    public Set<String> getCollectedUnqualifiedCollectionRoles() {
        return this.unqualifiedCollectedCollectionRoles;
    }

    public void collectUnqualifiedCollectionRole(String unqualifiedCollectionRole) {
        this.unqualifiedCollectedCollectionRoles.add(unqualifiedCollectionRole);
    }

    public boolean includeEmbeddedObjectId() {
        return this.includeEmbeddedObjectId;
    }

    public void setIncludeEmbeddedObjectId(boolean includeEmbeddedObjectId) {
        this.includeEmbeddedObjectId = includeEmbeddedObjectId;
    }
}

