/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import io.netty.util.Version;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;

public class TransportConstants {
    public static final String SSL_ENABLED_PROP_NAME = "sslEnabled";
    public static final String HTTP_ENABLED_PROP_NAME = "httpEnabled";
    public static final String HTTP_CLIENT_IDLE_PROP_NAME = "httpClientIdleTime";
    public static final String HTTP_CLIENT_IDLE_SCAN_PERIOD = "httpClientIdleScanPeriod";
    public static final String HTTP_RESPONSE_TIME_PROP_NAME = "httpResponseTime";
    public static final String HTTP_SERVER_SCAN_PERIOD_PROP_NAME = "httpServerScanPeriod";
    public static final String HTTP_REQUIRES_SESSION_ID = "httpRequiresSessionId";
    public static final String HTTP_UPGRADE_ENABLED_PROP_NAME = "httpUpgradeEnabled";
    public static final String HTTP_UPGRADE_ENDPOINT_PROP_NAME = "httpPpgradeEndpoint";
    public static final String USE_SERVLET_PROP_NAME = "useServlet";
    public static final String SERVLET_PATH = "servletPath";
    public static final String USE_NIO_PROP_NAME = "useNio";
    public static final String USE_NIO_GLOBAL_WORKER_POOL_PROP_NAME = "useNioGlobalWorkerPool";
    public static final String USE_INVM_PROP_NAME = "useInvm";
    @Deprecated
    public static final String PROTOCOL_PROP_NAME = "protocol";
    public static final String PROTOCOLS_PROP_NAME = "protocols";
    public static final String HOST_PROP_NAME = "host";
    public static final String PORT_PROP_NAME = "port";
    public static final String LOCAL_ADDRESS_PROP_NAME = "localAddress";
    public static final String LOCAL_PORT_PROP_NAME = "localPort";
    public static final String KEYSTORE_PROVIDER_PROP_NAME = "keyStoreProvider";
    public static final String KEYSTORE_PATH_PROP_NAME = "keyStorePath";
    public static final String KEYSTORE_PASSWORD_PROP_NAME = "keyStorePassword";
    public static final String TRUSTSTORE_PROVIDER_PROP_NAME = "trustStoreProvider";
    public static final String TRUSTSTORE_PATH_PROP_NAME = "trustStorePath";
    public static final String TRUSTSTORE_PASSWORD_PROP_NAME = "trustStorePassword";
    public static final String ENABLED_CIPHER_SUITES_PROP_NAME = "enabledCipherSuites";
    public static final String ENABLED_PROTOCOLS_PROP_NAME = "enabledProtocols";
    public static final String NEED_CLIENT_AUTH_PROP_NAME = "needClientAuth";
    public static final String BACKLOG_PROP_NAME = "backlog";
    public static final String NETTY_VERSION;
    public static final String TCP_NODELAY_PROPNAME = "tcpNoDelay";
    public static final String TCP_SENDBUFFER_SIZE_PROPNAME = "tcpSendBufferSize";
    public static final String TCP_RECEIVEBUFFER_SIZE_PROPNAME = "tcpReceiveBufferSize";
    public static final String NIO_REMOTING_THREADS_PROPNAME = "nioRemotingThreads";
    public static final String BATCH_DELAY = "batchDelay";
    public static final String DIRECT_DELIVER = "directDeliver";
    public static final String CLUSTER_CONNECTION = "clusterConnection";
    public static final String STOMP_CONSUMERS_CREDIT = "stompConsumerCredits";
    public static final int STOMP_DEFAULT_CONSUMERS_CREDIT = 10240;
    public static final boolean DEFAULT_SSL_ENABLED = false;
    public static final boolean DEFAULT_USE_NIO_GLOBAL_WORKER_POOL = true;
    public static final boolean DEFAULT_USE_INVM = false;
    public static final boolean DEFAULT_USE_SERVLET = false;
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 61616;
    public static final String DEFAULT_LOCAL_ADDRESS;
    public static final int DEFAULT_LOCAL_PORT = 0;
    public static final int DEFAULT_STOMP_PORT = 61613;
    public static final String DEFAULT_KEYSTORE_PROVIDER = "JKS";
    public static final String DEFAULT_KEYSTORE_PATH;
    public static final String DEFAULT_KEYSTORE_PASSWORD;
    public static final String DEFAULT_TRUSTSTORE_PROVIDER = "JKS";
    public static final String DEFAULT_TRUSTSTORE_PATH;
    public static final String DEFAULT_TRUSTSTORE_PASSWORD;
    public static final String DEFAULT_ENABLED_CIPHER_SUITES;
    public static final String DEFAULT_ENABLED_PROTOCOLS;
    public static final boolean DEFAULT_NEED_CLIENT_AUTH = false;
    public static final boolean DEFAULT_TCP_NODELAY = true;
    public static final int DEFAULT_TCP_SENDBUFFER_SIZE = 32768;
    public static final int DEFAULT_TCP_RECEIVEBUFFER_SIZE = 32768;
    public static final boolean DEFAULT_HTTP_ENABLED = false;
    public static final long DEFAULT_HTTP_CLIENT_IDLE_TIME = 500L;
    public static final long DEFAULT_HTTP_CLIENT_SCAN_PERIOD = 500L;
    public static final long DEFAULT_HTTP_RESPONSE_TIME = 10000L;
    public static final long DEFAULT_HTTP_SERVER_SCAN_PERIOD = 5000L;
    public static final boolean DEFAULT_HTTP_REQUIRES_SESSION_ID = false;
    public static final boolean DEFAULT_HTTP_UPGRADE_ENABLED = false;
    public static final String DEFAULT_SERVLET_PATH = "/messaging/ActiveMQServlet";
    public static final long DEFAULT_BATCH_DELAY = 0L;
    public static final boolean DEFAULT_DIRECT_DELIVER = true;
    public static final Set<String> ALLOWABLE_CONNECTOR_KEYS;
    public static final Set<String> ALLOWABLE_ACCEPTOR_KEYS;
    public static final String CONNECTION_TTL = "connectionTtl";
    public static final String STOMP_ENABLE_MESSAGE_ID = "stomp-enable-message-id";
    public static final String STOMP_MIN_LARGE_MESSAGE_SIZE = "stomp-min-large-message-size";
    public static final String NETTY_CONNECT_TIMEOUT = "connect-timeout-millis";
    public static final int DEFAULT_NETTY_CONNECT_TIMEOUT = -1;
    public static final String CONNECTIONS_ALLOWED = "connectionsAllowed";
    public static final long DEFAULT_CONNECTIONS_ALLOWED = -1L;

    static {
        DEFAULT_LOCAL_ADDRESS = null;
        DEFAULT_KEYSTORE_PATH = null;
        DEFAULT_KEYSTORE_PASSWORD = null;
        DEFAULT_TRUSTSTORE_PATH = null;
        DEFAULT_TRUSTSTORE_PASSWORD = null;
        DEFAULT_ENABLED_CIPHER_SUITES = null;
        DEFAULT_ENABLED_PROTOCOLS = null;
        HashSet<String> allowableAcceptorKeys = new HashSet<String>();
        allowableAcceptorKeys.add(SSL_ENABLED_PROP_NAME);
        allowableAcceptorKeys.add(HTTP_RESPONSE_TIME_PROP_NAME);
        allowableAcceptorKeys.add(HTTP_SERVER_SCAN_PERIOD_PROP_NAME);
        allowableAcceptorKeys.add(HTTP_UPGRADE_ENABLED_PROP_NAME);
        allowableAcceptorKeys.add(USE_NIO_PROP_NAME);
        allowableAcceptorKeys.add(USE_INVM_PROP_NAME);
        allowableAcceptorKeys.add(PROTOCOL_PROP_NAME);
        allowableAcceptorKeys.add(PROTOCOLS_PROP_NAME);
        allowableAcceptorKeys.add(HOST_PROP_NAME);
        allowableAcceptorKeys.add(PORT_PROP_NAME);
        allowableAcceptorKeys.add(KEYSTORE_PROVIDER_PROP_NAME);
        allowableAcceptorKeys.add(KEYSTORE_PATH_PROP_NAME);
        allowableAcceptorKeys.add(KEYSTORE_PASSWORD_PROP_NAME);
        allowableAcceptorKeys.add(TRUSTSTORE_PROVIDER_PROP_NAME);
        allowableAcceptorKeys.add(TRUSTSTORE_PATH_PROP_NAME);
        allowableAcceptorKeys.add(TRUSTSTORE_PASSWORD_PROP_NAME);
        allowableAcceptorKeys.add(ENABLED_CIPHER_SUITES_PROP_NAME);
        allowableAcceptorKeys.add(ENABLED_PROTOCOLS_PROP_NAME);
        allowableAcceptorKeys.add(NEED_CLIENT_AUTH_PROP_NAME);
        allowableAcceptorKeys.add(TCP_NODELAY_PROPNAME);
        allowableAcceptorKeys.add(TCP_SENDBUFFER_SIZE_PROPNAME);
        allowableAcceptorKeys.add(TCP_RECEIVEBUFFER_SIZE_PROPNAME);
        allowableAcceptorKeys.add(NIO_REMOTING_THREADS_PROPNAME);
        allowableAcceptorKeys.add(BATCH_DELAY);
        allowableAcceptorKeys.add(DIRECT_DELIVER);
        allowableAcceptorKeys.add(CLUSTER_CONNECTION);
        allowableAcceptorKeys.add(STOMP_CONSUMERS_CREDIT);
        allowableAcceptorKeys.add(STOMP_MIN_LARGE_MESSAGE_SIZE);
        allowableAcceptorKeys.add(CONNECTION_TTL);
        allowableAcceptorKeys.add(STOMP_ENABLE_MESSAGE_ID);
        allowableAcceptorKeys.add(CONNECTIONS_ALLOWED);
        allowableAcceptorKeys.add(ActiveMQDefaultConfiguration.getPropMaskPassword());
        allowableAcceptorKeys.add(ActiveMQDefaultConfiguration.getPropPasswordCodec());
        ALLOWABLE_ACCEPTOR_KEYS = Collections.unmodifiableSet(allowableAcceptorKeys);
        HashSet<String> allowableConnectorKeys = new HashSet<String>();
        allowableConnectorKeys.add(SSL_ENABLED_PROP_NAME);
        allowableConnectorKeys.add(HTTP_ENABLED_PROP_NAME);
        allowableConnectorKeys.add(HTTP_CLIENT_IDLE_PROP_NAME);
        allowableConnectorKeys.add(HTTP_CLIENT_IDLE_SCAN_PERIOD);
        allowableConnectorKeys.add(HTTP_REQUIRES_SESSION_ID);
        allowableConnectorKeys.add(HTTP_UPGRADE_ENABLED_PROP_NAME);
        allowableConnectorKeys.add(HTTP_UPGRADE_ENDPOINT_PROP_NAME);
        allowableConnectorKeys.add(USE_SERVLET_PROP_NAME);
        allowableConnectorKeys.add(SERVLET_PATH);
        allowableConnectorKeys.add(USE_NIO_PROP_NAME);
        allowableConnectorKeys.add(USE_NIO_GLOBAL_WORKER_POOL_PROP_NAME);
        allowableConnectorKeys.add(HOST_PROP_NAME);
        allowableConnectorKeys.add(PORT_PROP_NAME);
        allowableConnectorKeys.add(LOCAL_ADDRESS_PROP_NAME);
        allowableConnectorKeys.add(LOCAL_PORT_PROP_NAME);
        allowableConnectorKeys.add(KEYSTORE_PROVIDER_PROP_NAME);
        allowableConnectorKeys.add(KEYSTORE_PATH_PROP_NAME);
        allowableConnectorKeys.add(KEYSTORE_PASSWORD_PROP_NAME);
        allowableConnectorKeys.add(TRUSTSTORE_PROVIDER_PROP_NAME);
        allowableConnectorKeys.add(TRUSTSTORE_PATH_PROP_NAME);
        allowableConnectorKeys.add(TRUSTSTORE_PASSWORD_PROP_NAME);
        allowableConnectorKeys.add(ENABLED_CIPHER_SUITES_PROP_NAME);
        allowableConnectorKeys.add(ENABLED_PROTOCOLS_PROP_NAME);
        allowableConnectorKeys.add(TCP_NODELAY_PROPNAME);
        allowableConnectorKeys.add(TCP_SENDBUFFER_SIZE_PROPNAME);
        allowableConnectorKeys.add(TCP_RECEIVEBUFFER_SIZE_PROPNAME);
        allowableConnectorKeys.add(NIO_REMOTING_THREADS_PROPNAME);
        allowableConnectorKeys.add(BATCH_DELAY);
        allowableConnectorKeys.add(ActiveMQDefaultConfiguration.getPropMaskPassword());
        allowableConnectorKeys.add(ActiveMQDefaultConfiguration.getPropPasswordCodec());
        allowableConnectorKeys.add(NETTY_CONNECT_TIMEOUT);
        ALLOWABLE_CONNECTOR_KEYS = Collections.unmodifiableSet(allowableConnectorKeys);
        Version v = (Version)Version.identify().get("netty-transport");
        String version = v == null ? "unknown" : v.artifactVersion();
        NETTY_VERSION = version;
    }
}

