/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.core.transport.StatsChannelHandler;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001M3A!\u0001\u0002\u0001\u001b\t9b*\u001a;us\u000eC\u0017M\u001c8fY&s\u0017\u000e^5bY&TXM\u001d\u0006\u0003\u0007\u0011\t\u0011\u0002\u001e:b]N\u0004xN\u001d;\u000b\u0005\u00151\u0011\u0001B2pe\u0016T!a\u0002\u0005\u0002\rM,'O^3s\u0015\tI!\"\u0001\u0006j]\u001aLg.[:qC:T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u00012a\u0004\f\u0019\u001b\u0005\u0001\"BA\t\u0013\u0003\u001d\u0019\u0007.\u00198oK2T!a\u0005\u000b\u0002\u000b9,G\u000f^=\u000b\u0003U\t!![8\n\u0005]\u0001\"AE\"iC:tW\r\\%oSRL\u0017\r\\5{KJ\u0004\"aD\r\n\u0005i\u0001\"aB\"iC:tW\r\u001c\u0005\t\u000f\u0001\u0011\t\u0011)A\u00059A\u0011QDH\u0007\u0002\t%\u0011q\u0004\u0002\u0002\u000f!J|Go\\2pYN+'O^3s\u0011!\u0019\u0001A!A%\u0002\u0013\t\u0003c\u0001\u0012&O5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0005=Eft\u0017-\\3?!\tA\u0013&D\u0001\u0003\u0013\tQ#A\u0001\bOKR$\u0018\u0010\u0016:b]N\u0004xN\u001d;\t\u00111\u0002!\u0011!Q\u0001\n5\nq!\u001a8d_\u0012,'\u000f\u0005\u0002\u0010]%\u0011q\u0006\u0005\u0002\u0017\u0007\"\fgN\\3m\u001fV$(m\\;oI\"\u000bg\u000e\u001a7fe\")\u0011\u0007\u0001C\u0001e\u00051A(\u001b8jiz\"Ba\r\u001b6mA\u0011\u0001\u0006\u0001\u0005\u0006\u000fA\u0002\r\u0001\b\u0005\u0007\u0007A\"\t\u0019A\u0011\t\u000b1\u0002\u0004\u0019A\u0017\t\u000ba\u0002A\u0011I\u001d\u0002\u0017%t\u0017\u000e^\"iC:tW\r\u001c\u000b\u0003uu\u0002\"AI\u001e\n\u0005q\u001a#\u0001B+oSRDQAP\u001cA\u0002a\t!a\u00195\t\u000b\u0001\u0003A\u0011A!\u0002\u001f\r\u0014X-\u0019;f'NdWI\\4j]\u0016$\"A\u0011'\u0011\u0005\rSU\"\u0001#\u000b\u0005\u00153\u0015aA:tY*\u0011q\tS\u0001\u0004]\u0016$(\"A%\u0002\u000b)\fg/\u0019=\n\u0005-#%!C*T\u0019\u0016sw-\u001b8f\u0011\u0015)u\b1\u0001N!\tq\u0015+D\u0001P\u0015\t\u0001F!A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0003%>\u0013\u0001cU:m\u0007>tg-[4ve\u0006$\u0018n\u001c8")
public class NettyChannelInitializer
extends ChannelInitializer<Channel> {
    private final ProtocolServer server;
    private final Function0<NettyTransport> transport;
    private final ChannelOutboundHandler encoder;

    public void initChannel(Channel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("stats", (ChannelHandler)new StatsChannelHandler((NettyTransport)this.transport.apply()));
        SslConfiguration ssl = this.server.getConfiguration().ssl();
        Object object = ssl.enabled() ? pipeline.addLast("ssl", (ChannelHandler)new SslHandler(this.createSslEngine(ssl))) : BoxedUnit.UNIT;
        pipeline.addLast("decoder", (ChannelHandler)this.server.getDecoder());
        if (this.encoder != null) {
            pipeline.addLast("encoder", (ChannelHandler)this.encoder);
        }
    }

    public SSLEngine createSslEngine(SslConfiguration ssl) {
        SSLContext sslContext = ssl.sslContext() == null ? SslContextFactory.getContext((String)ssl.keyStoreFileName(), (char[])ssl.keyStorePassword(), (String)ssl.trustStoreFileName(), (char[])ssl.trustStorePassword()) : ssl.sslContext();
        return SslContextFactory.getEngine((SSLContext)sslContext, (boolean)false, (boolean)ssl.requireClientAuth());
    }

    public NettyChannelInitializer(ProtocolServer server, Function0<NettyTransport> transport, ChannelOutboundHandler encoder) {
        this.server = server;
        this.transport = transport;
        this.encoder = encoder;
    }
}

