/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.proton.plug;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.protocol.proton.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.core.protocol.proton.ProtonProtocolManager;
import org.apache.activemq.artemis.core.protocol.proton.plug.ProtonSessionIntegrationCallback;
import org.apache.activemq.artemis.core.protocol.proton.sasl.ActiveMQPlainSASL;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.proton.plug.AMQPConnectionCallback;
import org.proton.plug.AMQPConnectionContext;
import org.proton.plug.AMQPSessionCallback;
import org.proton.plug.ServerSASL;
import org.proton.plug.sasl.AnonymousServerSASL;

public class ActiveMQProtonConnectionCallback
implements AMQPConnectionCallback {
    private final ProtonProtocolManager manager;
    private final Connection connection;
    protected ActiveMQProtonRemotingConnection protonConnectionDelegate;
    protected AMQPConnectionContext amqpConnection;
    private final ReusableLatch latch = new ReusableLatch(0);
    private final Executor closeExecutor;

    public ActiveMQProtonConnectionCallback(ProtonProtocolManager manager, Connection connection, Executor closeExecutor) {
        this.manager = manager;
        this.connection = connection;
        this.closeExecutor = closeExecutor;
    }

    public ServerSASL[] getSASLMechnisms() {
        return new ServerSASL[]{new AnonymousServerSASL(), new ActiveMQPlainSASL(this.manager.getServer().getSecurityStore(), this.manager.getServer().getSecurityManager())};
    }

    public void close() {
    }

    public Executor getExeuctor() {
        if (this.protonConnectionDelegate != null) {
            return this.protonConnectionDelegate.getExecutor();
        }
        return null;
    }

    public void setConnection(AMQPConnectionContext connection) {
        this.amqpConnection = connection;
    }

    public AMQPConnectionContext getConnection() {
        return this.amqpConnection;
    }

    public ActiveMQProtonRemotingConnection getProtonConnectionDelegate() {
        return this.protonConnectionDelegate;
    }

    public void setProtonConnectionDelegate(ActiveMQProtonRemotingConnection protonConnectionDelegate) {
        this.protonConnectionDelegate = protonConnectionDelegate;
    }

    public void onTransport(ByteBuf byteBuf, AMQPConnectionContext amqpConnection) {
        int size = byteBuf.writerIndex();
        this.latch.countUp();
        this.connection.write((ActiveMQBuffer)new ChannelBufferWrapper(byteBuf, true), false, false, new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                ActiveMQProtonConnectionCallback.this.latch.countDown();
            }
        });
        if (amqpConnection.isSyncOnFlush()) {
            try {
                this.latch.await(5L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        amqpConnection.outputDone(size);
    }

    public AMQPSessionCallback createSessionCallback(AMQPConnectionContext connection) {
        return new ProtonSessionIntegrationCallback(this, this.manager, connection, this.connection, this.closeExecutor);
    }
}

