/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import org.infinispan.server.commons.controller.ReloadRequiredAddStepHandler;
import org.infinispan.server.jgroups.subsystem.Attribute;
import org.infinispan.server.jgroups.subsystem.ChannelResourceDefinition;
import org.infinispan.server.jgroups.subsystem.JGroupsModel;
import org.infinispan.server.jgroups.subsystem.JGroupsResourceDescriptionResolver;
import org.infinispan.server.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class RemoteSiteResourceDefinition
extends SimpleResourceDefinition {
    static final PathElement WILDCARD_PATH = RemoteSiteResourceDefinition.pathElement("*");
    static final SimpleAttributeDefinition CHANNEL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("channel", ModelType.STRING, false).setXmlName(Attribute.CHANNEL.getLocalName())).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    @Deprecated
    static final SimpleAttributeDefinition STACK = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("stack", ModelType.STRING, true).setXmlName(Attribute.STACK.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setDeprecated(JGroupsModel.VERSION_3_0_0.getVersion())).build();
    @Deprecated
    static final SimpleAttributeDefinition CLUSTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cluster", ModelType.STRING, true).setXmlName(Attribute.CLUSTER.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setDeprecated(JGroupsModel.VERSION_3_0_0.getVersion())).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CHANNEL, STACK};

    static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"remote-site", (String)name);
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(WILDCARD_PATH);
        if (JGroupsModel.VERSION_3_0_0.requiresTransformation(version)) {
            AttributeConverter converter = new AttributeConverter(){

                public void convertOperationParameter(PathAddress address, String name, ModelNode value, ModelNode operation, TransformationContext context) {
                }

                public void convertResourceAttribute(PathAddress address, String name, ModelNode value, TransformationContext context) {
                    ModelNode remoteSite = context.readResourceFromRoot(address).getModel();
                    String channelName = remoteSite.get(CHANNEL.getName()).asString();
                    if (STACK.getName().equals(name)) {
                        PathAddress subsystemAddress = address.subAddress(0, address.size() - 3);
                        PathAddress channelAddress = subsystemAddress.append(new PathElement[]{ChannelResourceDefinition.pathElement(channelName)});
                        ModelNode channel = context.readResourceFromRoot(channelAddress).getModel();
                        if (channel.hasDefined(ChannelResourceDefinition.STACK.getName())) {
                            value.set(channel.get(ChannelResourceDefinition.STACK.getName()).asString());
                        } else {
                            ModelNode subsystem = context.readResourceFromRoot(subsystemAddress).getModel();
                            value.set(subsystem.get(JGroupsSubsystemResourceDefinition.DEFAULT_STACK.getName()).asString());
                        }
                    } else if (CLUSTER.getName().equals(name)) {
                        value.set(channelName);
                    } else {
                        throw new IllegalStateException();
                    }
                }
            };
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setValueConverter(converter, new AttributeDefinition[]{STACK, CLUSTER})).setDiscard(DiscardAttributeChecker.ALWAYS, new AttributeDefinition[]{CHANNEL})).end();
        }
    }

    RemoteSiteResourceDefinition() {
        super(WILDCARD_PATH, (ResourceDescriptionResolver)new JGroupsResourceDescriptionResolver("remote-site"), (OperationStepHandler)new ReloadRequiredAddStepHandler(ATTRIBUTES), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attribute : ATTRIBUTES) {
            registration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)writeHandler);
        }
    }
}

