/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.List;
import java.util.function.BiFunction;
import org.infinispan.objectfilter.impl.syntax.BooleShannonExpansion;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;

final class ProtobufIndexedFieldProvider
implements BooleShannonExpansion.IndexedFieldProvider {
    private final Descriptor messageDescriptor;

    ProtobufIndexedFieldProvider(Descriptor messageDescriptor) {
        if (messageDescriptor == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        this.messageDescriptor = messageDescriptor;
    }

    public boolean isIndexed(List<String> propertyPath) {
        return this.getMetadata(propertyPath, IndexingMetadata::isFieldIndexed);
    }

    public boolean isStored(List<String> propertyPath) {
        return this.getMetadata(propertyPath, IndexingMetadata::isFieldStored);
    }

    private boolean getMetadata(List<String> propertyPath, BiFunction<IndexingMetadata, Integer, Boolean> metadataFun) {
        Descriptor md = this.messageDescriptor;
        int i = 0;
        for (String p : propertyPath) {
            boolean res;
            ++i;
            FieldDescriptor field = md.findFieldByName(p);
            if (field == null) break;
            IndexingMetadata indexingMetadata = (IndexingMetadata)md.getProcessedAnnotation("Indexed");
            boolean bl = res = indexingMetadata == null || metadataFun.apply(indexingMetadata, field.getNumber()) != false;
            if (!res) break;
            if (field.getJavaType() == JavaType.MESSAGE) {
                md = field.getMessageType();
                continue;
            }
            return i == propertyPath.size();
        }
        return false;
    }
}

