/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.as.connector.subsystems.datasources.ModifiableXaDataSource;
import org.jboss.msc.inject.ConcurrentMapInjector;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class XADataSourceConfigService
implements Service<ModifiableXaDataSource> {
    public static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"xa-data-source-config"});
    private final ModifiableXaDataSource dataSourceConfig;
    private final ConcurrentMap<String, String> xaDataSourceProperties = new ConcurrentHashMap<String, String>(0);

    public XADataSourceConfigService(ModifiableXaDataSource dataSourceConfig) {
        this.dataSourceConfig = dataSourceConfig;
    }

    public synchronized void start(StartContext startContext) throws StartException {
        for (Map.Entry xaDataSourceProperty : this.xaDataSourceProperties.entrySet()) {
            this.dataSourceConfig.addXaDataSourceProperty((String)xaDataSourceProperty.getKey(), (String)xaDataSourceProperty.getValue());
        }
    }

    public synchronized void stop(StopContext stopContext) {
    }

    public ModifiableXaDataSource getValue() throws IllegalStateException, IllegalArgumentException {
        return this.dataSourceConfig;
    }

    public Injector<String> getXaDataSourcePropertyInjector(String key) {
        return new ConcurrentMapInjector(this.xaDataSourceProperties, (Object)key);
    }
}

