/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.tom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jgroups.Address;
import org.jgroups.AnycastAddress;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.protocols.tom.DeliveryManagerImpl;
import org.jgroups.protocols.tom.DeliveryProtocol;
import org.jgroups.protocols.tom.DeliveryThread;
import org.jgroups.protocols.tom.MessageID;
import org.jgroups.protocols.tom.SenderManager;
import org.jgroups.protocols.tom.StatsCollector;
import org.jgroups.protocols.tom.ToaHeader;
import org.jgroups.stack.Protocol;

@MBean(description="Implementation of Total Order Anycast based on Skeen's Algorithm")
public class TOA
extends Protocol
implements DeliveryProtocol {
    private DeliveryManagerImpl deliverManager;
    private SenderManager senderManager;
    private final DeliveryThread deliverThread = new DeliveryThread(this);
    private Address localAddress;
    private final AtomicLong messageIdCounter = new AtomicLong(0L);
    private final StatsCollector statsCollector = new StatsCollector();
    private volatile View currentView;

    @Override
    public void start() throws Exception {
        this.deliverManager = new DeliveryManagerImpl();
        this.senderManager = new SenderManager();
        this.deliverThread.start(this.deliverManager);
        this.statsCollector.setStatsEnabled(this.statsEnabled());
    }

    @Override
    public void stop() {
        this.deliverThread.interrupt();
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                this.handleDownMessage(evt);
                return null;
            }
            case 8: {
                this.localAddress = (Address)evt.getArg();
                this.deliverThread.setLocalAddress(this.localAddress.toString());
                break;
            }
            case 6: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message message = (Message)evt.getArg();
                ToaHeader header = (ToaHeader)message.getHeader(this.id);
                if (header == null) break;
                switch (header.getType()) {
                    case 1: {
                        this.handleDataMessage(message, header);
                        break;
                    }
                    case 2: {
                        this.handleSequenceNumberPropose(message.getSrc(), header);
                        break;
                    }
                    case 4: {
                        this.handleFinalSequenceNumber(header);
                        break;
                    }
                    case 8: {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Received message " + message + " with SINGLE_DESTINATION header. delivering...");
                        }
                        this.deliverManager.deliverSingleDestinationMessage(message, header.getMessageID());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown header type received " + header);
                    }
                }
                return null;
            }
            case 6: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 8: {
                this.localAddress = (Address)evt.getArg();
                this.deliverThread.setLocalAddress(this.localAddress.toString());
                break;
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public void deliver(Message message) {
        message.setDest(this.localAddress);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Deliver message " + message + "(" + message.getHeader(this.id) + ") in total order");
        }
        this.up_prot.up(new Event(1, message));
        this.statsCollector.incrementMessageDeliver();
    }

    private void handleViewChange(View view) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Handle view " + view);
        }
        View oldView = this.currentView;
        this.currentView = view;
        List<Address> leavers = View.leftMembers(oldView, view);
        this.deliverManager.removeLeavers(leavers);
        Collection<MessageID> pendingSentMessages = this.senderManager.getPendingMessageIDs();
        for (MessageID messageID : pendingSentMessages) {
            long finalSequenceNumber = this.senderManager.removeLeavers(messageID, leavers);
            if (finalSequenceNumber == -1L) continue;
            ToaHeader finalHeader = ToaHeader.newFinalMessageHeader(messageID, finalSequenceNumber);
            Message finalMessage = new Message().src(this.localAddress).putHeader(this.id, finalHeader).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL, Message.Flag.DONT_BUNDLE);
            Set<Address> destinations = this.senderManager.getDestination(messageID);
            if (destinations.contains(this.localAddress)) {
                destinations.remove(this.localAddress);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Message " + messageID + " is ready to be deliver. Final sequencer number is " + finalSequenceNumber);
            }
            this.send(destinations, finalMessage, false);
            if (!this.senderManager.markSent(messageID)) continue;
            this.deliverManager.markReadyToDeliver(messageID, finalSequenceNumber);
        }
    }

    private void handleDownMessage(Event evt) {
        Message message = (Message)evt.getArg();
        Address dest = message.getDest();
        if (dest != null && dest instanceof AnycastAddress && !message.isFlagSet(Message.Flag.NO_TOTAL_ORDER)) {
            this.sendTotalOrderAnycastMessage(this.extract((AnycastAddress)dest), message);
        } else if (dest != null && dest instanceof AnycastAddress) {
            this.send(this.extract((AnycastAddress)dest), message, true);
        } else {
            this.down_prot.down(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTotalOrderAnycastMessage(List<Address> destinations, Message message) {
        boolean trace = this.log.isTraceEnabled();
        long startTime = this.statsCollector.now();
        long duration = -1L;
        boolean deliverToMySelf = destinations.contains(this.localAddress);
        if (destinations.size() == 1) {
            MessageID messageID = this.generateId();
            message.putHeader(this.id, ToaHeader.createSingleDestinationHeader(messageID));
            message.setDest(destinations.get(0));
            if (trace) {
                this.log.trace("Sending total order anycast message " + message + " (" + message.getHeader(this.id) + ") to single destination");
            }
            if (deliverToMySelf) {
                this.deliverManager.deliverSingleDestinationMessage(message, messageID);
            } else {
                this.down_prot.down(new Event(1, message));
            }
            return;
        }
        try {
            MessageID messageID = this.generateId();
            long sequenceNumber = -1L;
            ToaHeader header = ToaHeader.newDataMessageHeader(messageID, destinations);
            message.putHeader(this.id, header);
            if (deliverToMySelf) {
                sequenceNumber = this.deliverManager.addLocalMessageToDeliver(messageID, message, header);
            }
            if (trace) {
                this.log.trace("Sending total order anycast message " + message + " (" + message.getHeader(this.id) + ") to " + destinations);
            }
            this.senderManager.addNewMessageToSend(messageID, destinations, sequenceNumber, deliverToMySelf);
            this.send(destinations, message, false);
            duration = this.statsCollector.now() - startTime;
            this.statsCollector.addAnycastSentDuration(duration, destinations.size() - (deliverToMySelf ? 1 : 0));
        }
        catch (Exception e) {
            try {
                this.logException("Exception caught while sending anycast message. Error is " + e.getLocalizedMessage(), e);
                this.statsCollector.addAnycastSentDuration(duration, destinations.size() - (deliverToMySelf ? 1 : 0));
            }
            catch (Throwable throwable) {
                this.statsCollector.addAnycastSentDuration(duration, destinations.size() - (deliverToMySelf ? 1 : 0));
                throw throwable;
            }
        }
    }

    private MessageID generateId() {
        return new MessageID(this.localAddress, this.messageIdCounter.getAndIncrement());
    }

    private void send(Collection<Address> destinations, Message msg, boolean sendToMyself) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sending anycast total order message " + msg + " to " + destinations);
        }
        for (Address address : destinations) {
            if (!sendToMyself && address.equals(this.localAddress)) continue;
            Message cpy = msg.copy();
            cpy.setDest(address);
            this.down_prot.down(new Event(1, cpy));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDataMessage(Message message, ToaHeader header) {
        long startTime = this.statsCollector.now();
        long duration = -1L;
        try {
            MessageID messageID = header.getMessageID();
            long myProposeSequenceNumber = this.deliverManager.addRemoteMessageToDeliver(messageID, message, header.getSequencerNumber());
            if (this.log.isTraceEnabled()) {
                this.log.trace("Received the message with " + header + ". The proposed sequence number is " + myProposeSequenceNumber);
            }
            ToaHeader newHeader = ToaHeader.newProposeMessageHeader(messageID, myProposeSequenceNumber);
            Message proposeMessage = new Message().src(this.localAddress).dest(messageID.getAddress()).putHeader(this.id, newHeader).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL, Message.Flag.DONT_BUNDLE);
            this.down_prot.down(new Event(1, proposeMessage));
            duration = this.statsCollector.now() - startTime;
        }
        catch (Exception e) {
            this.logException("Exception caught while processing the data message " + header.getMessageID(), e);
        }
        finally {
            this.statsCollector.addDataMessageDuration(duration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSequenceNumberPropose(Address from, ToaHeader header) {
        long startTime = this.statsCollector.now();
        long duration = -1L;
        boolean lastProposeReceived = false;
        boolean trace = this.log.isTraceEnabled();
        try {
            MessageID messageID = header.getMessageID();
            if (trace) {
                this.log.trace("Received the proposed sequence number message with " + header + " from " + from);
            }
            this.deliverManager.updateSequenceNumber(header.getSequencerNumber());
            long finalSequenceNumber = this.senderManager.addPropose(messageID, from, header.getSequencerNumber());
            if (finalSequenceNumber != -1L) {
                lastProposeReceived = true;
                ToaHeader finalHeader = ToaHeader.newFinalMessageHeader(messageID, finalSequenceNumber);
                Message finalMessage = new Message().src(this.localAddress).putHeader(this.id, finalHeader).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL, Message.Flag.DONT_BUNDLE);
                Set<Address> destinations = this.senderManager.getDestination(messageID);
                if (destinations.contains(this.localAddress)) {
                    destinations.remove(this.localAddress);
                }
                if (trace) {
                    this.log.trace("Message " + messageID + " is ready to be deliver. Final sequencer number is " + finalSequenceNumber);
                }
                this.send(destinations, finalMessage, false);
                if (this.senderManager.markSent(messageID)) {
                    this.deliverManager.markReadyToDeliver(messageID, finalSequenceNumber);
                }
            }
            duration = this.statsCollector.now() - startTime;
        }
        catch (Exception e) {
            this.logException("Exception caught while processing the propose sequence number for " + header.getMessageID(), e);
        }
        finally {
            this.statsCollector.addProposeSequenceNumberDuration(duration, lastProposeReceived);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFinalSequenceNumber(ToaHeader header) {
        long startTime = this.statsCollector.now();
        long duration = -1L;
        try {
            MessageID messageID = header.getMessageID();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Received the final sequence number message with " + header);
            }
            this.deliverManager.markReadyToDeliver(messageID, header.getSequencerNumber());
            duration = this.statsCollector.now() - startTime;
        }
        catch (Exception e) {
            this.logException("Exception caught while processing the final sequence number for " + header.getMessageID(), e);
        }
        finally {
            this.statsCollector.addFinalSequenceNumberDuration(duration);
        }
    }

    private void logException(String msg, Exception e) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(msg, e);
        } else if (this.log.isWarnEnabled()) {
            this.log.warn(msg + ". Error is " + e.getLocalizedMessage());
        }
    }

    private List<Address> extract(AnycastAddress anycastAddress) {
        Collection<Address> addresses = anycastAddress.getAddresses();
        if (addresses == null) {
            return new ArrayList<Address>(this.currentView.getMembers());
        }
        return new ArrayList<Address>(addresses);
    }

    @ManagedOperation
    public String getMessageList() {
        return this.deliverManager.getMessageSet().toString();
    }

    @Override
    public void enableStats(boolean flag) {
        super.enableStats(flag);
        this.statsCollector.setStatsEnabled(flag);
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.statsCollector.clearStats();
    }

    @ManagedAttribute(description="The average duration (in milliseconds) in processing and sending the anycast message to all the recipients", writable=false)
    public double getAvgToaSendDuration() {
        return this.statsCollector.getAvgAnycastSentDuration();
    }

    @ManagedAttribute(description="The average duration (in milliseconds) in processing a data message received", writable=false)
    public double getAvgDataMessageReceivedDuration() {
        return this.statsCollector.getAvgDataMessageReceivedDuration();
    }

    @ManagedAttribute(description="The average duration (in milliseconds) in processing a propose message received(not the last one", writable=false)
    public double getAvgProposeMessageReceivedDuration() {
        return this.statsCollector.getAvgProposeMesageReceivedDuration();
    }

    @ManagedAttribute(description="The average duration (in milliseconds) in processing the last propose message received. This last propose message will originate the sending of the final message", writable=false)
    public double getAvgLastProposeMessageReceivedDuration() {
        return this.statsCollector.getAvgLastProposeMessageReceivedDuration();
    }

    @ManagedAttribute(description="The average duration (in milliseconds) in processing a final message received", writable=false)
    public double getAvgFinalMessageReceivedDuration() {
        return this.statsCollector.getAvgFinalMessageReceivedDuration();
    }

    @ManagedAttribute(description="The number of anycast messages sent", writable=false)
    public int getNumberOfAnycastMessagesSent() {
        return this.statsCollector.getNumberOfAnycastMessagesSent();
    }

    @ManagedAttribute(description="The number of final anycast sent", writable=false)
    public int getNumberOfFinalAnycastSent() {
        return this.statsCollector.getNumberOfFinalAnycastsSent();
    }

    @ManagedAttribute(description="The number of anycast messages delivered", writable=false)
    public int getNumberOfAnycastMessagesDelivered() {
        return this.statsCollector.getAnycastDelivered();
    }

    @ManagedAttribute(description="The number of propose messages sent", writable=false)
    public int getNumberOfProposeMessageSent() {
        return this.statsCollector.getNumberOfProposeMessagesSent();
    }

    @ManagedAttribute(description="The number of final messages delivered", writable=false)
    public int getNumberOfFinalMessagesDelivered() {
        return this.statsCollector.getNumberOfFinalMessagesDelivered();
    }

    @ManagedAttribute(description="The number of data messages delivered", writable=false)
    public int getNumberOfDataMessagesDelivered() {
        return this.statsCollector.getNumberOfProposeMessagesSent();
    }

    @ManagedAttribute(description="The number of propose messages received", writable=false)
    public int getNumberOfProposeMessageReceived() {
        return this.statsCollector.getNumberOfProposeMessagesReceived();
    }

    @ManagedAttribute(description="The average number of unicasts messages created per anycast message", writable=false)
    public double getAvgNumberOfUnicastSentPerAnycast() {
        return this.statsCollector.getAvgNumberOfUnicastSentPerAnycast();
    }
}

