/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.stomp;

public interface Stomp {
    public static final String NULL = "\u0000";
    public static final String NEWLINE = "\n";

    public static interface Headers {
        public static final String SEPARATOR = ":";
        public static final String RECEIPT_REQUESTED = "receipt";
        public static final String TRANSACTION = "transaction";
        public static final String CONTENT_LENGTH = "content-length";
        public static final String ACCEPT_VERSION = "accept-version";
        public static final String CONTENT_TYPE = "content-type";

        public static interface Ack {
            public static final String MESSAGE_ID = "message-id";
            public static final String SUBSCRIPTION = "subscription";
            public static final String ID = "id";
        }

        public static interface Connected {
            public static final String SESSION = "session";
            public static final String RESPONSE_ID = "response-id";
            public static final String VERSION = "version";
            public static final String SERVER = "server";
            public static final String HEART_BEAT = "heart-beat";
        }

        public static interface Error {
            public static final String MESSAGE = "message";
            public static final String VERSION = "version";
        }

        public static interface Connect {
            public static final String LOGIN = "login";
            public static final String PASSCODE = "passcode";
            public static final String CLIENT_ID = "client-id";
            public static final String REQUEST_ID = "request-id";
            public static final String ACCEPT_VERSION = "accept-version";
            public static final String HOST = "host";
            public static final Object HEART_BEAT = "heart-beat";
        }

        public static interface Unsubscribe {
            public static final String DESTINATION = "destination";
            public static final String ID = "id";
            public static final String DURABLE_SUBSCRIBER_NAME = "durable-subscriber-name";
        }

        public static interface Subscribe {
            public static final String DESTINATION = "destination";
            public static final String ACK_MODE = "ack";
            public static final String ID = "id";
            public static final String SELECTOR = "selector";
            public static final String DURABLE_SUBSCRIBER_NAME = "durable-subscriber-name";
            public static final String NO_LOCAL = "no-local";

            public static interface AckModeValues {
                public static final String AUTO = "auto";
                public static final String CLIENT = "client";
                public static final String CLIENT_INDIVIDUAL = "client-individual";
            }
        }

        public static interface Message {
            public static final String MESSAGE_ID = "message-id";
            public static final String DESTINATION = "destination";
            public static final String CORRELATION_ID = "correlation-id";
            public static final String EXPIRATION_TIME = "expires";
            public static final String REPLY_TO = "reply-to";
            public static final String PRORITY = "priority";
            public static final String REDELIVERED = "redelivered";
            public static final String TIMESTAMP = "timestamp";
            public static final String TYPE = "type";
            public static final String SUBSCRIPTION = "subscription";
            public static final String ACK = "ack";
        }

        public static interface Send {
            public static final String DESTINATION = "destination";
            public static final String CORRELATION_ID = "correlation-id";
            public static final String REPLY_TO = "reply-to";
            public static final String EXPIRATION_TIME = "expires";
            public static final String PRIORITY = "priority";
            public static final String TYPE = "type";
            public static final Object PERSISTENT = "persistent";
        }

        public static interface Response {
            public static final String RECEIPT_ID = "receipt-id";
        }
    }

    public static interface Responses {
        public static final String CONNECTED = "CONNECTED";
        public static final String ERROR = "ERROR";
        public static final String MESSAGE = "MESSAGE";
        public static final String RECEIPT = "RECEIPT";
    }

    public static interface Commands {
        public static final String CONNECT = "CONNECT";
        public static final String SEND = "SEND";
        public static final String DISCONNECT = "DISCONNECT";
        public static final String SUBSCRIBE = "SUBSCRIBE";
        public static final String UNSUBSCRIBE = "UNSUBSCRIBE";
        public static final String BEGIN = "BEGIN";
        public static final String COMMIT = "COMMIT";
        public static final String ABORT = "ABORT";
        public static final String ACK = "ACK";
        public static final String NACK = "NACK";
        public static final String STOMP = "STOMP";
    }
}

