/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.hql;

import java.beans.IntrospectionException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.infinispan.objectfilter.impl.hql.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.objectfilter.impl.util.ReflectionHelper;
import org.jboss.logging.Logger;

public final class ReflectionPropertyHelper
extends ObjectPropertyHelper<Class<?>> {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)ReflectionPropertyHelper.class.getName());
    private static final Map<Class<?>, Class<?>> primitives = new HashMap();

    public ReflectionPropertyHelper(EntityNamesResolver entityNamesResolver) {
        super(entityNamesResolver);
    }

    @Override
    public Class<?> getEntityMetadata(String targetTypeName) {
        return this.entityNamesResolver.getClassFromName(targetTypeName);
    }

    @Override
    public Class<?> getPrimitivePropertyType(String entityType, List<String> propertyPath) {
        Class type = this.entityNamesResolver.getClassFromName(entityType);
        if (type == null) {
            throw log.getUnknownEntity(entityType);
        }
        try {
            Class<?> propType = this.getPropertyAccessor(type, propertyPath).getPropertyType();
            if (propType.isEnum()) {
                return propType;
            }
            if (primitives.containsKey(propType)) {
                return primitives.get(propType);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean hasProperty(String entityType, List<String> propertyPath) {
        return this.hasProperty(entityType, propertyPath.toArray(new String[propertyPath.size()]));
    }

    @Override
    public boolean hasEmbeddedProperty(String entityType, List<String> propertyPath) {
        Class entity = this.entityNamesResolver.getClassFromName(entityType);
        if (entity == null) {
            throw log.getUnknownEntity(entityType);
        }
        try {
            Class<?> propType = this.getPropertyAccessor(entity, propertyPath).getPropertyType();
            return propType != null && !propType.isEnum() && !primitives.containsKey(propType);
        }
        catch (IntrospectionException e) {
            return false;
        }
    }

    @Override
    public boolean isRepeatedProperty(String entityType, List<String> propertyPath) {
        Class entity = this.entityNamesResolver.getClassFromName(entityType);
        if (entity == null) {
            throw log.getUnknownEntity(entityType);
        }
        try {
            ReflectionHelper.PropertyAccessor a = ReflectionHelper.getAccessor(entity, propertyPath.get(0));
            if (a.isMultiple()) {
                return true;
            }
            for (int i = 1; i < propertyPath.size(); ++i) {
                if (!(a = a.getAccessor(propertyPath.get(i))).isMultiple()) continue;
                return true;
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return false;
    }

    private boolean hasProperty(String entityType, String ... propertyPath) {
        Class entity = this.entityNamesResolver.getClassFromName(entityType);
        if (entity == null) {
            throw log.getUnknownEntity(entityType);
        }
        try {
            Class<?> propType = this.getPropertyAccessor(entity, Arrays.asList(propertyPath)).getPropertyType();
            return propType != null;
        }
        catch (IntrospectionException e) {
            return false;
        }
    }

    private ReflectionHelper.PropertyAccessor getPropertyAccessor(Class<?> entityClass, List<String> propertyPath) throws IntrospectionException {
        ReflectionHelper.PropertyAccessor accessor = ReflectionHelper.getAccessor(entityClass, propertyPath.get(0));
        for (int i = 1; i < propertyPath.size(); ++i) {
            accessor = accessor.getAccessor(propertyPath.get(i));
        }
        return accessor;
    }

    static {
        primitives.put(Date.class, Date.class);
        primitives.put(Instant.class, Instant.class);
        primitives.put(String.class, String.class);
        primitives.put(Character.class, Character.class);
        primitives.put(Character.TYPE, Character.class);
        primitives.put(Double.class, Double.class);
        primitives.put(Double.TYPE, Double.class);
        primitives.put(Float.class, Float.class);
        primitives.put(Float.TYPE, Float.class);
        primitives.put(Long.class, Long.class);
        primitives.put(Long.TYPE, Long.class);
        primitives.put(Integer.class, Integer.class);
        primitives.put(Integer.TYPE, Integer.class);
        primitives.put(Short.class, Short.class);
        primitives.put(Short.TYPE, Short.class);
        primitives.put(Byte.class, Byte.class);
        primitives.put(Byte.TYPE, Byte.class);
        primitives.put(Boolean.class, Boolean.class);
        primitives.put(Boolean.TYPE, Boolean.class);
    }
}

