/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jxc;

import com.sun.tools.jxc.ApBasedTask;
import com.sun.tools.jxc.ap.SchemaGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.processing.Processor;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Commandline;

public class SchemaGenTask
extends ApBasedTask {
    private final List<Schema> schemas = new ArrayList<Schema>();
    private File episode;

    @Override
    protected void setupCommandlineSwitches(Commandline cmd) {
        cmd.createArgument().setValue("-proc:only");
    }

    @Override
    protected String getCompilationMessage() {
        return "Generating schema from ";
    }

    @Override
    protected String getFailedMessage() {
        return "schema generation failed";
    }

    public Schema createSchema() {
        Schema s = new Schema();
        this.schemas.add(s);
        return s;
    }

    public void setEpisode(File f) {
        this.episode = f;
    }

    @Override
    protected Processor getProcessor() {
        HashMap<String, File> m = new HashMap<String, File>();
        for (Schema schema : this.schemas) {
            if (m.containsKey(schema.namespace)) {
                throw new BuildException("the same namespace is specified twice");
            }
            m.put(schema.namespace, schema.file);
        }
        SchemaGenerator r = new SchemaGenerator(m);
        if (this.episode != null) {
            r.setEpisodeFile(this.episode);
        }
        return r;
    }

    public class Schema {
        private String namespace;
        private File file;

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public void setFile(String fileName) {
            File dest = SchemaGenTask.this.getDestdir();
            if (dest == null) {
                dest = SchemaGenTask.this.getProject().getBaseDir();
            }
            this.file = new File(dest, fileName);
        }
    }
}

