/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.FormAuthenticationMechanism;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.session.Session;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.util.SavedRequest;
import io.undertow.util.Headers;
import io.undertow.util.RedirectBuilder;
import java.io.IOException;
import java.security.AccessController;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class ServletFormAuthenticationMechanism
extends FormAuthenticationMechanism {
    private static final String SESSION_KEY = "io.undertow.servlet.form.auth.redirect.location";
    public static final String SAVE_ORIGINAL_REQUEST = "save-original-request";
    private final boolean saveOriginalRequest;

    @Deprecated
    public ServletFormAuthenticationMechanism(String name, String loginPage, String errorPage) {
        super(name, loginPage, errorPage);
        this.saveOriginalRequest = true;
    }

    @Deprecated
    public ServletFormAuthenticationMechanism(String name, String loginPage, String errorPage, String postLocation) {
        super(name, loginPage, errorPage, postLocation);
        this.saveOriginalRequest = true;
    }

    public ServletFormAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage, String postLocation) {
        super(formParserFactory, name, loginPage, errorPage, postLocation);
        this.saveOriginalRequest = true;
    }

    public ServletFormAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage) {
        super(formParserFactory, name, loginPage, errorPage);
        this.saveOriginalRequest = true;
    }

    public ServletFormAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage, IdentityManager identityManager) {
        super(formParserFactory, name, loginPage, errorPage, identityManager);
        this.saveOriginalRequest = true;
    }

    public ServletFormAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage, IdentityManager identityManager, boolean saveOriginalRequest) {
        super(formParserFactory, name, loginPage, errorPage, identityManager);
        this.saveOriginalRequest = saveOriginalRequest;
    }

    protected Integer servePage(HttpServerExchange exchange, String location) {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        ServletRequest req = servletRequestContext.getServletRequest();
        ServletResponse resp = servletRequestContext.getServletResponse();
        RequestDispatcher disp = req.getRequestDispatcher(location);
        exchange.getResponseHeaders().add(Headers.CACHE_CONTROL, "no-cache, no-store, must-revalidate");
        exchange.getResponseHeaders().add(Headers.PRAGMA, "no-cache");
        exchange.getResponseHeaders().add(Headers.EXPIRES, "0");
        try {
            disp.forward(req, resp);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    protected void storeInitialLocation(HttpServerExchange exchange) {
        if (!this.saveOriginalRequest) {
            return;
        }
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpSessionImpl httpSession = servletRequestContext.getCurrentServletContext().getSession(exchange, true);
        Session session = System.getSecurityManager() == null ? httpSession.getSession() : AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction(httpSession));
        session.setAttribute(SESSION_KEY, (Object)RedirectBuilder.redirect((HttpServerExchange)exchange, (String)exchange.getRelativePath()));
        SavedRequest.trySaveRequest(exchange);
    }

    protected void handleRedirectBack(HttpServerExchange exchange) {
        Session session;
        String path;
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletResponse resp = (HttpServletResponse)servletRequestContext.getServletResponse();
        HttpSessionImpl httpSession = servletRequestContext.getCurrentServletContext().getSession(exchange, false);
        if (httpSession != null && (path = (String)(session = System.getSecurityManager() == null ? httpSession.getSession() : AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction(httpSession))).getAttribute(SESSION_KEY)) != null) {
            try {
                resp.sendRedirect(path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Factory
    implements AuthenticationMechanismFactory {
        private final IdentityManager identityManager;

        public Factory(IdentityManager identityManager) {
            this.identityManager = identityManager;
        }

        public AuthenticationMechanism create(String mechanismName, FormParserFactory formParserFactory, Map<String, String> properties) {
            boolean saveOriginal = true;
            if (properties.containsKey(ServletFormAuthenticationMechanism.SAVE_ORIGINAL_REQUEST)) {
                saveOriginal = Boolean.parseBoolean(properties.get(ServletFormAuthenticationMechanism.SAVE_ORIGINAL_REQUEST));
            }
            return new ServletFormAuthenticationMechanism(formParserFactory, mechanismName, properties.get("login_page"), properties.get("error_page"), this.identityManager, saveOriginal);
        }
    }
}

