/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.constraintdefinition;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.validation.ConstraintValidator;
import org.hibernate.validator.internal.engine.constraintdefinition.ConstraintDefinitionContribution;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.spi.constraintdefinition.ConstraintDefinitionContributor;

class ConstraintDefinitionBuilderContextImpl<A extends Annotation>
implements ConstraintDefinitionContributor.ConstraintDefinitionBuilderContext<A> {
    private final ConstraintDefinitionContributor.ConstraintDefinitionBuilder builder;
    private final Class<A> constraintType;
    private boolean includeExistingValidators = true;
    private final List<Class<? extends ConstraintValidator<A, ?>>> validatorTypes = CollectionHelper.newArrayList();

    public ConstraintDefinitionBuilderContextImpl(ConstraintDefinitionContributor.ConstraintDefinitionBuilder builder, Class<A> constraintType) {
        this.builder = builder;
        this.constraintType = constraintType;
    }

    @Override
    public ConstraintDefinitionContributor.ConstraintDefinitionBuilderContext<A> includeExistingValidators(boolean include) {
        this.includeExistingValidators = include;
        return this;
    }

    @Override
    public ConstraintDefinitionContributor.ConstraintDefinitionBuilderContext<A> validatedBy(Class<? extends ConstraintValidator<A, ?>> validatorType) {
        this.validatorTypes.add(validatorType);
        return this;
    }

    @Override
    public <B extends Annotation> ConstraintDefinitionContributor.ConstraintDefinitionBuilderContext<B> constraint(Class<B> constraintType) {
        return this.builder.constraint(constraintType);
    }

    ConstraintDefinitionContribution<?> build() {
        return new ConstraintDefinitionContribution<A>(this.constraintType, this.validatorTypes, this.includeExistingValidators);
    }
}

