/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.codec;

import java.nio.charset.Charset;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.cli.interpreter.codec.AbstractCodec;
import org.infinispan.cli.interpreter.codec.CodecException;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.server.memcached.MemcachedValue;
import org.infinispan.util.logging.LogFactory;

public class MemcachedCodec
extends AbstractCodec {
    private static final Log log = (Log)LogFactory.getLog(Interpreter.class, Log.class);
    private Charset UTF8 = Charset.forName("UTF-8");

    public MemcachedCodec() {
        try {
            Class.forName("org.infinispan.server.memcached.MemcachedServer");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName() {
        return "memcached";
    }

    @Override
    public Object encodeKey(Object key) {
        return key;
    }

    @Override
    public Object encodeValue(Object value) throws CodecException {
        if (value != null) {
            if (value instanceof MemcachedValue) {
                return value;
            }
            if (value instanceof byte[]) {
                return new MemcachedValue((byte[])value, 1L, 0L);
            }
            if (value instanceof String) {
                return new MemcachedValue(((String)value).getBytes(this.UTF8), 1L, 0L);
            }
            throw log.valueEncodingFailed(value.getClass().getName(), this.getName());
        }
        return null;
    }

    @Override
    public Object decodeKey(Object key) {
        return key;
    }

    @Override
    public Object decodeValue(Object value) {
        if (value != null) {
            MemcachedValue mv = (MemcachedValue)value;
            return new String(mv.data(), this.UTF8);
        }
        return null;
    }
}

