/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.metadata.Metadata;

public class VersionedEntry {
    public static final ExcludeEmptyFilter EXCLUDE_EMPTY_EXTRACT_VALUE = new ExcludeEmptyFilter();
    private final Object value;
    private final Object version;
    private final long timestamp;

    public VersionedEntry(Object value, Object version, long timestamp) {
        this.value = value;
        this.version = version;
        this.timestamp = timestamp;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getVersion() {
        return this.version;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VersionedEntry{");
        sb.append("value=").append(this.value);
        sb.append(", version=").append(this.version);
        sb.append(", timestamp=").append(this.timestamp);
        sb.append('}');
        return sb.toString();
    }

    public static class ExcludeEmptyExtractValueExternalizer
    implements AdvancedExternalizer<ExcludeEmptyFilter> {
        public Set<Class<? extends ExcludeEmptyFilter>> getTypeClasses() {
            return Collections.singleton(ExcludeEmptyFilter.class);
        }

        public Integer getId() {
            return 1207;
        }

        public void writeObject(ObjectOutput output, ExcludeEmptyFilter object) throws IOException {
        }

        public ExcludeEmptyFilter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return EXCLUDE_EMPTY_EXTRACT_VALUE;
        }
    }

    public static class Externalizer
    implements AdvancedExternalizer<VersionedEntry> {
        public Set<Class<? extends VersionedEntry>> getTypeClasses() {
            return Collections.singleton(VersionedEntry.class);
        }

        public Integer getId() {
            return 1206;
        }

        public void writeObject(ObjectOutput output, VersionedEntry object) throws IOException {
            output.writeObject(object.value);
            output.writeObject(object.version);
            output.writeLong(object.timestamp);
        }

        public VersionedEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object value = input.readObject();
            Object version = input.readObject();
            long timestamp = input.readLong();
            return new VersionedEntry(value, version, timestamp);
        }
    }

    private static class ExcludeEmptyFilter
    implements KeyValueFilter<Object, Object>,
    Converter<Object, Object, Object> {
        private ExcludeEmptyFilter() {
        }

        public boolean accept(Object key, Object value, Metadata metadata) {
            if (value instanceof VersionedEntry) {
                return ((VersionedEntry)value).getValue() != null;
            }
            return true;
        }

        public Object convert(Object key, Object value, Metadata metadata) {
            if (value instanceof VersionedEntry) {
                return ((VersionedEntry)value).getValue();
            }
            return value;
        }
    }
}

