/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.iteration.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.iteration.impl.EntryRetriever;
import org.infinispan.remoting.transport.Address;

public class EntryResponseCommand<K, C>
extends BaseRpcCommand
implements TopologyAffectedCommand {
    public static final byte COMMAND_ID = 42;
    private UUID identifier;
    private Set<Integer> completedSegments;
    private Set<Integer> inDoubtSegments;
    private Collection<CacheEntry<K, C>> values;
    private CacheException e;
    private int topologyId = -1;
    private Address origin;
    private EntryRetriever<K, ?> entryRetrieverManager;

    private EntryResponseCommand() {
        super(null);
    }

    public EntryResponseCommand(String cacheName) {
        super(cacheName);
    }

    public EntryResponseCommand(Address origin, String cacheName, UUID identifier, Set<Integer> completedSegments, Set<Integer> inDoubtSegments, Collection<CacheEntry<K, C>> values, CacheException e) {
        super(cacheName);
        this.origin = origin;
        this.identifier = identifier;
        this.completedSegments = completedSegments;
        this.inDoubtSegments = inDoubtSegments;
        this.values = values;
        this.e = e;
    }

    @Inject
    public void init(EntryRetriever<K, ?> entryRetrieverManager) {
        this.entryRetrieverManager = entryRetrieverManager;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        this.entryRetrieverManager.receiveResponse(this.identifier, this.origin, this.completedSegments, this.inDoubtSegments, this.values, this.e);
        return null;
    }

    @Override
    public byte getCommandId() {
        return 42;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.origin);
        MarshallUtil.marshallUUID((UUID)this.identifier, (ObjectOutput)output, (boolean)false);
        MarshallUtil.marshallCollection(this.completedSegments, (ObjectOutput)output);
        MarshallUtil.marshallCollection(this.inDoubtSegments, (ObjectOutput)output);
        MarshallUtil.marshallCollection(this.values, (ObjectOutput)output);
        output.writeObject((Object)this.e);
        output.writeInt(this.topologyId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.origin = (Address)input.readObject();
        this.identifier = MarshallUtil.unmarshallUUID((ObjectInput)input, (boolean)false);
        this.completedSegments = (Set)MarshallUtil.unmarshallCollectionUnbounded((ObjectInput)input, HashSet::new);
        this.inDoubtSegments = (Set)MarshallUtil.unmarshallCollectionUnbounded((ObjectInput)input, HashSet::new);
        this.values = MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
        this.e = (CacheException)((Object)input.readObject());
        this.topologyId = input.readInt();
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public String toString() {
        return "EntryResponseCommand{identifier=" + this.identifier + ", completedSegments=" + this.completedSegments + ", inDoubtSegments=" + this.inDoubtSegments + ", values=" + this.values + ", topologyId=" + this.topologyId + ", origin=" + this.origin + '}';
    }
}

