/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query;

import org.hibernate.envers.RevisionType;
import org.hibernate.envers.query.criteria.AuditConjunction;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.AuditDisjunction;
import org.hibernate.envers.query.criteria.AuditId;
import org.hibernate.envers.query.criteria.AuditProperty;
import org.hibernate.envers.query.criteria.AuditRelatedId;
import org.hibernate.envers.query.criteria.internal.LogicalAuditExpression;
import org.hibernate.envers.query.criteria.internal.NotAuditExpression;
import org.hibernate.envers.query.internal.property.EntityPropertyName;
import org.hibernate.envers.query.internal.property.RevisionNumberPropertyName;
import org.hibernate.envers.query.internal.property.RevisionPropertyPropertyName;
import org.hibernate.envers.query.internal.property.RevisionTypePropertyName;

public class AuditEntity {
    private AuditEntity() {
    }

    public static AuditId id() {
        return new AuditId();
    }

    public static AuditProperty<Object> property(String propertyName) {
        return new AuditProperty<Object>(new EntityPropertyName(propertyName));
    }

    public static AuditProperty<Number> revisionNumber() {
        return new AuditProperty<Number>(new RevisionNumberPropertyName());
    }

    public static AuditProperty<Object> revisionProperty(String propertyName) {
        return new AuditProperty<Object>(new RevisionPropertyPropertyName(propertyName));
    }

    public static AuditProperty<RevisionType> revisionType() {
        return new AuditProperty<RevisionType>(new RevisionTypePropertyName());
    }

    public static AuditRelatedId relatedId(String propertyName) {
        return new AuditRelatedId(new EntityPropertyName(propertyName));
    }

    public static AuditCriterion and(AuditCriterion lhs, AuditCriterion rhs) {
        return new LogicalAuditExpression(lhs, rhs, "and");
    }

    public static AuditCriterion or(AuditCriterion lhs, AuditCriterion rhs) {
        return new LogicalAuditExpression(lhs, rhs, "or");
    }

    public static AuditCriterion not(AuditCriterion expression) {
        return new NotAuditExpression(expression);
    }

    public static AuditConjunction conjunction() {
        return new AuditConjunction();
    }

    public static AuditDisjunction disjunction() {
        return new AuditDisjunction();
    }
}

