/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.ctx;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Subject {
    private URI category;
    private List attributes;
    public static final URI DEFAULT_CATEGORY = URI.create("urn:oasis:names:tc:xacml:1.0:subject-category:access-subject");

    public Subject(Set attributes) {
        this(null, attributes);
    }

    public Subject(List attributes) {
        this(null, attributes);
    }

    public Subject(URI category, Set attributes) {
        this.category = category == null ? DEFAULT_CATEGORY : category;
        this.attributes = Collections.unmodifiableList(new ArrayList(attributes));
    }

    public Subject(URI category, List attributes) {
        this.category = category == null ? DEFAULT_CATEGORY : category;
        this.attributes = Collections.unmodifiableList(attributes);
    }

    public URI getCategory() {
        return this.category;
    }

    public Set getAttributes() {
        return Collections.unmodifiableSet(new HashSet(this.attributes));
    }

    public List getAttributesAsList() {
        return this.attributes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : ((Object)this.attributes).hashCode());
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Subject other = (Subject)obj;
        if (this.attributes == null ? other.attributes != null : !((Object)this.attributes).equals(other.attributes)) {
            return false;
        }
        return !(this.category == null ? other.category != null : !this.category.equals(other.category));
    }
}

