/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;

public abstract class CommandHandlerWithArguments
implements CommandHandler {
    private int maxArgumentIndex = -1;
    private Map<String, CommandArgument> args = Collections.emptyMap();
    private List<CommandArgument> argList = Collections.emptyList();

    public void addArgument(CommandArgument arg) {
        if (arg.getIndex() > -1) {
            int n = this.maxArgumentIndex = arg.getIndex() > this.maxArgumentIndex ? arg.getIndex() : this.maxArgumentIndex;
        }
        if (arg.getFullName() == null) {
            throw new IllegalArgumentException("Full name can't be null");
        }
        switch (this.argList.size()) {
            case 0: {
                this.argList = Collections.singletonList(arg);
                this.args = new HashMap<String, CommandArgument>();
                break;
            }
            case 1: {
                CommandArgument tmp = this.argList.get(0);
                this.argList = new ArrayList<CommandArgument>();
                this.argList.add(tmp);
            }
            default: {
                this.argList.add(arg);
            }
        }
        this.args.put(arg.getFullName(), arg);
        if (arg.getShortName() != null) {
            this.args.put(arg.getShortName(), arg);
        }
    }

    @Override
    public CommandArgument getArgument(CommandContext ctx, String name) {
        return this.args.get(name);
    }

    @Override
    public boolean hasArgument(CommandContext ctx, String name) {
        return this.args.containsKey(name);
    }

    @Override
    public boolean hasArgument(CommandContext ctx, int index) {
        throw new UnsupportedOperationException("not used yet");
    }

    @Override
    public Collection<CommandArgument> getArguments(CommandContext ctx) {
        return this.argList;
    }

    protected void recognizeArguments(CommandContext ctx) throws CommandFormatException {
        Set<String> specifiedNames = ctx.getParsedCommandLine().getPropertyNames();
        if (!this.args.keySet().containsAll(specifiedNames)) {
            HashSet<String> unrecognized = new HashSet<String>(specifiedNames);
            unrecognized.removeAll(this.args.keySet());
            throw new CommandFormatException("Unrecognized arguments: " + unrecognized);
        }
        if (ctx.getParsedCommandLine().getOtherProperties().size() - 1 > this.maxArgumentIndex) {
            throw new CommandFormatException("The command accepts " + (this.maxArgumentIndex + 1) + " unnamed argument(s) but received: " + ctx.getParsedCommandLine().getOtherProperties());
        }
    }
}

