/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import java.util.Collections;
import java.util.List;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.Option;

public final class EnumValueDescriptor {
    private final String name;
    private final int number;
    private final String documentation;
    private final List<Option> options;
    private EnumDescriptor enumDescriptor;
    private FileDescriptor fileDescriptor;

    private EnumValueDescriptor(Builder builder) {
        this.name = builder.name;
        this.number = builder.number;
        this.documentation = builder.documentation;
        this.options = Collections.unmodifiableList(builder.options);
    }

    public String getName() {
        return this.name;
    }

    public int getNumber() {
        return this.number;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public EnumDescriptor getContainingEnum() {
        return this.enumDescriptor;
    }

    void setContainingEnum(EnumDescriptor enumDescriptor) {
        this.enumDescriptor = enumDescriptor;
    }

    public FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }

    void setFileDescriptor(FileDescriptor fileDescriptor) {
        this.fileDescriptor = fileDescriptor;
    }

    public static final class Builder {
        private String name;
        private int number;
        private String documentation;
        private List<Option> options;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withTag(int tag) {
            this.number = tag;
            return this;
        }

        public Builder withDocumentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public Builder withOptions(List<Option> options) {
            this.options = options;
            return this;
        }

        public EnumValueDescriptor build() {
            return new EnumValueDescriptor(this);
        }
    }
}

