/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.charset.Charset;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.Slices;

public final class SliceInput
extends InputStream
implements DataInput {
    private final Slice slice;
    private int position;

    public SliceInput(Slice slice) {
        this.slice = slice;
    }

    public int position() {
        return this.position;
    }

    public void setPosition(int position) {
        if (position < 0 || position > this.slice.length()) {
            throw new IndexOutOfBoundsException();
        }
        this.position = position;
    }

    public boolean isReadable() {
        return this.available() > 0;
    }

    @Override
    public int available() {
        return this.slice.length() - this.position;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public int read() {
        return this.readByte();
    }

    @Override
    public byte readByte() {
        if (this.position == this.slice.length()) {
            throw new IndexOutOfBoundsException();
        }
        return this.slice.getByte(this.position++);
    }

    @Override
    public int readUnsignedByte() {
        return (short)(this.readByte() & 0xFF);
    }

    @Override
    public short readShort() {
        short v = this.slice.getShort(this.position);
        this.position += 2;
        return v;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFF;
    }

    @Override
    public int readInt() {
        int v = this.slice.getInt(this.position);
        this.position += 4;
        return v;
    }

    public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() {
        long v = this.slice.getLong(this.position);
        this.position += 8;
        return v;
    }

    public byte[] readByteArray(int length) {
        byte[] value = this.slice.copyBytes(this.position, length);
        this.position += length;
        return value;
    }

    public Slice readBytes(int length) {
        if (length == 0) {
            return Slices.EMPTY_SLICE;
        }
        Slice value = this.slice.slice(this.position, length);
        this.position += length;
        return value;
    }

    public Slice readSlice(int length) {
        Slice newSlice = this.slice.slice(this.position, length);
        this.position += length;
        return newSlice;
    }

    @Override
    public void readFully(byte[] destination) {
        this.readBytes(destination);
    }

    public void readBytes(byte[] destination) {
        this.readBytes(destination, 0, destination.length);
    }

    @Override
    public void readFully(byte[] destination, int offset, int length) {
        this.readBytes(destination, offset, length);
    }

    public void readBytes(byte[] destination, int destinationIndex, int length) {
        this.slice.getBytes(this.position, destination, destinationIndex, length);
        this.position += length;
    }

    public void readBytes(Slice destination) {
        this.readBytes(destination, destination.length());
    }

    public void readBytes(Slice destination, int length) {
        if (length > destination.length()) {
            throw new IndexOutOfBoundsException();
        }
        this.readBytes(destination, destination.length(), length);
    }

    public void readBytes(Slice destination, int destinationIndex, int length) {
        this.slice.getBytes(this.position, destination, destinationIndex, length);
        this.position += length;
    }

    public void readBytes(ByteBuffer destination) {
        int length = destination.remaining();
        this.slice.getBytes(this.position, destination);
        this.position += length;
    }

    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        int readBytes = this.slice.getBytes(this.position, out, length);
        this.position += readBytes;
        return readBytes;
    }

    public void readBytes(OutputStream out, int length) throws IOException {
        this.slice.getBytes(this.position, out, length);
        this.position += length;
    }

    @Override
    public int skipBytes(int length) {
        length = Math.min(length, this.available());
        this.position += length;
        return length;
    }

    public Slice slice() {
        return this.slice.slice(this.position, this.available());
    }

    public ByteBuffer toByteBuffer() {
        return this.slice.toByteBuffer(this.position, this.available());
    }

    public String toString(Charset charset) {
        return this.slice.toString(this.position, this.available(), charset);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + "ridx=" + this.position + ", " + "cap=" + this.slice.length() + ')';
    }

    @Override
    public char readChar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public float readFloat() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double readDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() {
        throw new UnsupportedOperationException();
    }
}

