/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset;

import com.sun.rowset.CachedRowSetImpl;
import com.sun.rowset.JdbcRowSetImpl;
import com.sun.rowset.JdbcRowSetResourceBundle;
import com.sun.rowset.WebRowSetImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetListener;
import javax.sql.RowSetMetaData;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.JoinRowSet;
import javax.sql.rowset.Joinable;
import javax.sql.rowset.RowSetMetaDataImpl;
import javax.sql.rowset.WebRowSet;
import javax.sql.rowset.spi.SyncProvider;
import javax.sql.rowset.spi.SyncProviderException;

public class JoinRowSetImpl
extends WebRowSetImpl
implements JoinRowSet {
    private Vector<CachedRowSetImpl> vecRowSetsInJOIN = new Vector();
    private CachedRowSetImpl crsInternal = new CachedRowSetImpl();
    private Vector<Integer> vecJoinType = new Vector();
    private Vector<String> vecTableNames = new Vector();
    private int iMatchKey = -1;
    private String strMatchKey = null;
    boolean[] supportedJOINs = new boolean[]{false, true, false, false, false};
    private WebRowSet wrs;
    static final long serialVersionUID = -5590501621560008453L;

    public JoinRowSetImpl() throws SQLException {
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void addRowSet(Joinable rowset) throws SQLException {
        int i;
        CachedRowSetImpl cRowset;
        boolean boolColId = false;
        boolean boolColName = false;
        if (!(rowset instanceof RowSet)) {
            throw new SQLException(this.resBundle.handleGetObject("joinrowsetimpl.notinstance").toString());
        }
        if (rowset instanceof JdbcRowSetImpl) {
            cRowset = new CachedRowSetImpl();
            cRowset.populate((RowSet)((Object)rowset));
            if (cRowset.size() == 0) {
                throw new SQLException(this.resBundle.handleGetObject("joinrowsetimpl.emptyrowset").toString());
            }
            try {
                int matchColumnCount = 0;
                for (int i2 = 0; i2 < rowset.getMatchColumnIndexes().length && rowset.getMatchColumnIndexes()[i2] != -1; ++i2) {
                    ++matchColumnCount;
                }
                int[] pCol = new int[matchColumnCount];
                for (i = 0; i < matchColumnCount; ++i) {
                    pCol[i] = rowset.getMatchColumnIndexes()[i];
                }
                cRowset.setMatchColumn(pCol);
            }
            catch (SQLException matchColumnCount) {}
        } else {
            cRowset = (CachedRowSetImpl)rowset;
            if (cRowset.size() == 0) {
                throw new SQLException(this.resBundle.handleGetObject("joinrowsetimpl.emptyrowset").toString());
            }
        }
        try {
            this.iMatchKey = cRowset.getMatchColumnIndexes()[0];
        }
        catch (SQLException sqle) {
            boolColId = true;
        }
        try {
            this.strMatchKey = cRowset.getMatchColumnNames()[0];
        }
        catch (SQLException sqle) {
            boolColName = true;
        }
        if (boolColId && boolColName) {
            throw new SQLException(this.resBundle.handleGetObject("joinrowsetimpl.matchnotset").toString());
        }
        if (boolColId) {
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (int i3 = 0; i3 < cRowset.getMatchColumnNames().length && (this.strMatchKey = cRowset.getMatchColumnNames()[i3]) != null; ++i3) {
                this.iMatchKey = cRowset.findColumn(this.strMatchKey);
                indices.add(this.iMatchKey);
            }
            int[] indexes = new int[indices.size()];
            for (i = 0; i < indices.size(); ++i) {
                indexes[i] = (Integer)indices.get(i);
            }
            cRowset.setMatchColumn(indexes);
        }
        this.initJOIN(cRowset);
    }

    @Override
    public void addRowSet(RowSet rowset, int columnIdx) throws SQLException {
        ((CachedRowSetImpl)rowset).setMatchColumn(columnIdx);
        this.addRowSet((Joinable)((Object)rowset));
    }

    @Override
    public void addRowSet(RowSet rowset, String columnName) throws SQLException {
        ((CachedRowSetImpl)rowset).setMatchColumn(columnName);
        this.addRowSet((Joinable)((Object)rowset));
    }

    @Override
    public void addRowSet(RowSet[] rowset, int[] columnIdx) throws SQLException {
        if (rowset.length != columnIdx.length) {
            throw new SQLException(this.resBundle.handleGetObject("joinrowsetimpl.numnotequal").toString());
        }
        for (int i = 0; i < rowset.length; ++i) {
            ((CachedRowSetImpl)rowset[i]).setMatchColumn(columnIdx[i]);
            this.addRowSet((Joinable)((Object)rowset[i]));
        }
    }

    @Override
    public void addRowSet(RowSet[] rowset, String[] columnName) throws SQLException {
        if (rowset.length != columnName.length) {
            throw new SQLException(this.resBundle.handleGetObject("joinrowsetimpl.numnotequal").toString());
        }
        for (int i = 0; i < rowset.length; ++i) {
            ((CachedRowSetImpl)rowset[i]).setMatchColumn(columnName[i]);
            this.addRowSet((Joinable)((Object)rowset[i]));
        }
    }

    public Collection getRowSets() throws SQLException {
        return this.vecRowSetsInJOIN;
    }

    @Override
    public String[] getRowSetNames() throws SQLException {
        Object[] arr = this.vecTableNames.toArray();
        String[] strArr = new String[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            strArr[i] = arr[i].toString();
        }
        return strArr;
    }

    @Override
    public CachedRowSet toCachedRowSet() throws SQLException {
        return this.crsInternal;
    }

    @Override
    public boolean supportsCrossJoin() {
        return this.supportedJOINs[0];
    }

    @Override
    public boolean supportsInnerJoin() {
        return this.supportedJOINs[1];
    }

    @Override
    public boolean supportsLeftOuterJoin() {
        return this.supportedJOINs[2];
    }

    @Override
    public boolean supportsRightOuterJoin() {
        return this.supportedJOINs[3];
    }

    @Override
    public boolean supportsFullJoin() {
        return this.supportedJOINs[4];
    }

    @Override
    public void setJoinType(int type) throws SQLException {
        if (type >= 0 && type <= 4) {
            if (type != 1) {
                throw new SQLException(this.resBundle.handleGetObject("joinrowsetimpl.notsupported").toString());
            }
        } else {
            throw new SQLException(this.resBundle.handleGetObject("joinrowsetimpl.notdefined").toString());
        }
        Integer Intgr = 1;
        this.vecJoinType.add(Intgr);
    }

    private boolean checkforMatchColumn(Joinable rs) throws SQLException {
        int[] i = rs.getMatchColumnIndexes();
        return i.length > 0;
    }

    private void initJOIN(CachedRowSet rowset) throws SQLException {
        try {
            CachedRowSetImpl cRowset = (CachedRowSetImpl)rowset;
            CachedRowSetImpl crsTemp = new CachedRowSetImpl();
            RowSetMetaDataImpl rsmd = new RowSetMetaDataImpl();
            if (this.vecRowSetsInJOIN.isEmpty()) {
                this.crsInternal = (CachedRowSetImpl)rowset.createCopy();
                this.crsInternal.setMetaData((RowSetMetaDataImpl)cRowset.getMetaData());
                this.vecRowSetsInJOIN.add(cRowset);
            } else {
                int i;
                if (this.vecRowSetsInJOIN.size() - this.vecJoinType.size() == 2) {
                    this.setJoinType(1);
                } else if (this.vecRowSetsInJOIN.size() - this.vecJoinType.size() == 1) {
                    // empty if block
                }
                this.vecTableNames.add(this.crsInternal.getTableName());
                this.vecTableNames.add(cRowset.getTableName());
                int rowCount2 = cRowset.size();
                int rowCount1 = this.crsInternal.size();
                int matchColumnCount = 0;
                for (i = 0; i < this.crsInternal.getMatchColumnIndexes().length && this.crsInternal.getMatchColumnIndexes()[i] != -1; ++i) {
                    ++matchColumnCount;
                }
                rsmd.setColumnCount(this.crsInternal.getMetaData().getColumnCount() + cRowset.getMetaData().getColumnCount() - matchColumnCount);
                crsTemp.setMetaData(rsmd);
                this.crsInternal.beforeFirst();
                cRowset.beforeFirst();
                for (i = 1; i <= rowCount1 && !this.crsInternal.isAfterLast(); ++i) {
                    if (!this.crsInternal.next()) continue;
                    cRowset.beforeFirst();
                    for (int j = 1; j <= rowCount2 && !cRowset.isAfterLast(); ++j) {
                        int p;
                        if (!cRowset.next()) continue;
                        boolean match = true;
                        for (int k = 0; k < matchColumnCount; ++k) {
                            if (this.crsInternal.getObject(this.crsInternal.getMatchColumnIndexes()[k]).equals(cRowset.getObject(cRowset.getMatchColumnIndexes()[k]))) continue;
                            match = false;
                            break;
                        }
                        if (!match) continue;
                        int colc = 0;
                        crsTemp.moveToInsertRow();
                        for (p = 1; p <= this.crsInternal.getMetaData().getColumnCount(); ++p) {
                            match = false;
                            for (int k = 0; k < matchColumnCount; ++k) {
                                if (p != this.crsInternal.getMatchColumnIndexes()[k]) continue;
                                match = true;
                                break;
                            }
                            if (!match) {
                                crsTemp.updateObject(++colc, this.crsInternal.getObject(p));
                                rsmd.setColumnName(colc, this.crsInternal.getMetaData().getColumnName(p));
                                rsmd.setTableName(colc, this.crsInternal.getTableName());
                                rsmd.setColumnType(p, this.crsInternal.getMetaData().getColumnType(p));
                                rsmd.setAutoIncrement(p, this.crsInternal.getMetaData().isAutoIncrement(p));
                                rsmd.setCaseSensitive(p, this.crsInternal.getMetaData().isCaseSensitive(p));
                                rsmd.setCatalogName(p, this.crsInternal.getMetaData().getCatalogName(p));
                                rsmd.setColumnDisplaySize(p, this.crsInternal.getMetaData().getColumnDisplaySize(p));
                                rsmd.setColumnLabel(p, this.crsInternal.getMetaData().getColumnLabel(p));
                                rsmd.setColumnType(p, this.crsInternal.getMetaData().getColumnType(p));
                                rsmd.setColumnTypeName(p, this.crsInternal.getMetaData().getColumnTypeName(p));
                                rsmd.setCurrency(p, this.crsInternal.getMetaData().isCurrency(p));
                                rsmd.setNullable(p, this.crsInternal.getMetaData().isNullable(p));
                                rsmd.setPrecision(p, this.crsInternal.getMetaData().getPrecision(p));
                                rsmd.setScale(p, this.crsInternal.getMetaData().getScale(p));
                                rsmd.setSchemaName(p, this.crsInternal.getMetaData().getSchemaName(p));
                                rsmd.setSearchable(p, this.crsInternal.getMetaData().isSearchable(p));
                                rsmd.setSigned(p, this.crsInternal.getMetaData().isSigned(p));
                                continue;
                            }
                            crsTemp.updateObject(++colc, this.crsInternal.getObject(p));
                            rsmd.setColumnName(colc, this.crsInternal.getMetaData().getColumnName(p));
                            rsmd.setTableName(colc, this.crsInternal.getTableName() + "#" + cRowset.getTableName());
                            rsmd.setColumnType(p, this.crsInternal.getMetaData().getColumnType(p));
                            rsmd.setAutoIncrement(p, this.crsInternal.getMetaData().isAutoIncrement(p));
                            rsmd.setCaseSensitive(p, this.crsInternal.getMetaData().isCaseSensitive(p));
                            rsmd.setCatalogName(p, this.crsInternal.getMetaData().getCatalogName(p));
                            rsmd.setColumnDisplaySize(p, this.crsInternal.getMetaData().getColumnDisplaySize(p));
                            rsmd.setColumnLabel(p, this.crsInternal.getMetaData().getColumnLabel(p));
                            rsmd.setColumnType(p, this.crsInternal.getMetaData().getColumnType(p));
                            rsmd.setColumnTypeName(p, this.crsInternal.getMetaData().getColumnTypeName(p));
                            rsmd.setCurrency(p, this.crsInternal.getMetaData().isCurrency(p));
                            rsmd.setNullable(p, this.crsInternal.getMetaData().isNullable(p));
                            rsmd.setPrecision(p, this.crsInternal.getMetaData().getPrecision(p));
                            rsmd.setScale(p, this.crsInternal.getMetaData().getScale(p));
                            rsmd.setSchemaName(p, this.crsInternal.getMetaData().getSchemaName(p));
                            rsmd.setSearchable(p, this.crsInternal.getMetaData().isSearchable(p));
                            rsmd.setSigned(p, this.crsInternal.getMetaData().isSigned(p));
                        }
                        for (int q = 1; q <= cRowset.getMetaData().getColumnCount(); ++q) {
                            match = false;
                            for (int k = 0; k < matchColumnCount; ++k) {
                                if (q != cRowset.getMatchColumnIndexes()[k]) continue;
                                match = true;
                                break;
                            }
                            if (!match) {
                                crsTemp.updateObject(++colc, cRowset.getObject(q));
                                rsmd.setColumnName(colc, cRowset.getMetaData().getColumnName(q));
                                rsmd.setTableName(colc, cRowset.getTableName());
                                rsmd.setColumnType(p + q - 1, cRowset.getMetaData().getColumnType(q));
                                rsmd.setAutoIncrement(p + q - 1, cRowset.getMetaData().isAutoIncrement(q));
                                rsmd.setCaseSensitive(p + q - 1, cRowset.getMetaData().isCaseSensitive(q));
                                rsmd.setCatalogName(p + q - 1, cRowset.getMetaData().getCatalogName(q));
                                rsmd.setColumnDisplaySize(p + q - 1, cRowset.getMetaData().getColumnDisplaySize(q));
                                rsmd.setColumnLabel(p + q - 1, cRowset.getMetaData().getColumnLabel(q));
                                rsmd.setColumnType(p + q - 1, cRowset.getMetaData().getColumnType(q));
                                rsmd.setColumnTypeName(p + q - 1, cRowset.getMetaData().getColumnTypeName(q));
                                rsmd.setCurrency(p + q - 1, cRowset.getMetaData().isCurrency(q));
                                rsmd.setNullable(p + q - 1, cRowset.getMetaData().isNullable(q));
                                rsmd.setPrecision(p + q - 1, cRowset.getMetaData().getPrecision(q));
                                rsmd.setScale(p + q - 1, cRowset.getMetaData().getScale(q));
                                rsmd.setSchemaName(p + q - 1, cRowset.getMetaData().getSchemaName(q));
                                rsmd.setSearchable(p + q - 1, cRowset.getMetaData().isSearchable(q));
                                rsmd.setSigned(p + q - 1, cRowset.getMetaData().isSigned(q));
                                continue;
                            }
                            --p;
                        }
                        crsTemp.insertRow();
                        crsTemp.moveToCurrentRow();
                    }
                }
                crsTemp.setMetaData(rsmd);
                crsTemp.setOriginal();
                int[] pCol = new int[matchColumnCount];
                for (int i2 = 0; i2 < matchColumnCount; ++i2) {
                    pCol[i2] = this.crsInternal.getMatchColumnIndexes()[i2];
                }
                this.crsInternal = (CachedRowSetImpl)crsTemp.createCopy();
                this.crsInternal.setMatchColumn(pCol);
                this.crsInternal.setMetaData(rsmd);
                this.vecRowSetsInJOIN.add(cRowset);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw new SQLException(this.resBundle.handleGetObject("joinrowsetimpl.initerror").toString() + sqle);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException(this.resBundle.handleGetObject("joinrowsetimpl.genericerr").toString() + e);
        }
    }

    @Override
    public String getWhereClause() throws SQLException {
        int i;
        String strWhereClause = "Select ";
        String tabName = "";
        String strTabName = "";
        int sz = this.vecRowSetsInJOIN.size();
        for (i = 0; i < sz; ++i) {
            CachedRowSetImpl crs = this.vecRowSetsInJOIN.get(i);
            int cols = crs.getMetaData().getColumnCount();
            tabName = tabName.concat(crs.getTableName());
            strTabName = strTabName.concat(tabName + ", ");
            int j = 1;
            while (j < cols) {
                strWhereClause = strWhereClause.concat(tabName + "." + crs.getMetaData().getColumnName(j++));
                strWhereClause = strWhereClause.concat(", ");
            }
        }
        strWhereClause = strWhereClause.substring(0, strWhereClause.lastIndexOf(","));
        strWhereClause = strWhereClause.concat(" from ");
        strWhereClause = strWhereClause.concat(strTabName);
        strWhereClause = strWhereClause.substring(0, strWhereClause.lastIndexOf(","));
        strWhereClause = strWhereClause.concat(" where ");
        for (i = 0; i < sz; ++i) {
            strWhereClause = strWhereClause.concat(this.vecRowSetsInJOIN.get(i).getMatchColumnNames()[0]);
            strWhereClause = i % 2 != 0 ? strWhereClause.concat("=") : strWhereClause.concat(" and");
            strWhereClause = strWhereClause.concat(" ");
        }
        return strWhereClause;
    }

    @Override
    public boolean next() throws SQLException {
        return this.crsInternal.next();
    }

    @Override
    public void close() throws SQLException {
        this.crsInternal.close();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.crsInternal.wasNull();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.crsInternal.getString(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.crsInternal.getBoolean(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.crsInternal.getByte(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.crsInternal.getShort(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.crsInternal.getInt(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.crsInternal.getLong(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.crsInternal.getFloat(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.crsInternal.getDouble(columnIndex);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.crsInternal.getBigDecimal(columnIndex);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.crsInternal.getBytes(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.crsInternal.getDate(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.crsInternal.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.crsInternal.getTimestamp(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.crsInternal.getAsciiStream(columnIndex);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.crsInternal.getUnicodeStream(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.crsInternal.getBinaryStream(columnIndex);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.crsInternal.getString(columnName);
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.crsInternal.getBoolean(columnName);
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.crsInternal.getByte(columnName);
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.crsInternal.getShort(columnName);
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.crsInternal.getInt(columnName);
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.crsInternal.getLong(columnName);
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.crsInternal.getFloat(columnName);
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.crsInternal.getDouble(columnName);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.crsInternal.getBigDecimal(columnName);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.crsInternal.getBytes(columnName);
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.crsInternal.getDate(columnName);
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.crsInternal.getTime(columnName);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.crsInternal.getTimestamp(columnName);
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.crsInternal.getAsciiStream(columnName);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.crsInternal.getUnicodeStream(columnName);
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.crsInternal.getBinaryStream(columnName);
    }

    @Override
    public SQLWarning getWarnings() {
        return this.crsInternal.getWarnings();
    }

    @Override
    public void clearWarnings() {
        this.crsInternal.clearWarnings();
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.crsInternal.getCursorName();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.crsInternal.getMetaData();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.crsInternal.getObject(columnIndex);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return this.crsInternal.getObject(columnIndex, map);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.crsInternal.getObject(columnName);
    }

    @Override
    public Object getObject(String columnName, Map<String, Class<?>> map) throws SQLException {
        return this.crsInternal.getObject(columnName, map);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.crsInternal.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.crsInternal.getCharacterStream(columnName);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.crsInternal.getBigDecimal(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.crsInternal.getBigDecimal(columnName);
    }

    @Override
    public int size() {
        return this.crsInternal.size();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.crsInternal.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.crsInternal.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.crsInternal.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.crsInternal.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.crsInternal.beforeFirst();
    }

    @Override
    public void afterLast() throws SQLException {
        this.crsInternal.afterLast();
    }

    @Override
    public boolean first() throws SQLException {
        return this.crsInternal.first();
    }

    @Override
    public boolean last() throws SQLException {
        return this.crsInternal.last();
    }

    @Override
    public int getRow() throws SQLException {
        return this.crsInternal.getRow();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        return this.crsInternal.absolute(row);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return this.crsInternal.relative(rows);
    }

    @Override
    public boolean previous() throws SQLException {
        return this.crsInternal.previous();
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return this.crsInternal.findColumn(columnName);
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.crsInternal.rowUpdated();
    }

    @Override
    public boolean columnUpdated(int indexColumn) throws SQLException {
        return this.crsInternal.columnUpdated(indexColumn);
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.crsInternal.rowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.crsInternal.rowDeleted();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.crsInternal.updateNull(columnIndex);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.crsInternal.updateBoolean(columnIndex, x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.crsInternal.updateByte(columnIndex, x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.crsInternal.updateShort(columnIndex, x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.crsInternal.updateInt(columnIndex, x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.crsInternal.updateLong(columnIndex, x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.crsInternal.updateFloat(columnIndex, x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.crsInternal.updateDouble(columnIndex, x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.crsInternal.updateBigDecimal(columnIndex, x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.crsInternal.updateString(columnIndex, x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.crsInternal.updateBytes(columnIndex, x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.crsInternal.updateDate(columnIndex, x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.crsInternal.updateTime(columnIndex, x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.crsInternal.updateTimestamp(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.crsInternal.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.crsInternal.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.crsInternal.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.crsInternal.updateObject(columnIndex, x, scale);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.crsInternal.updateObject(columnIndex, x);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.crsInternal.updateNull(columnName);
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.crsInternal.updateBoolean(columnName, x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.crsInternal.updateByte(columnName, x);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.crsInternal.updateShort(columnName, x);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.crsInternal.updateInt(columnName, x);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.crsInternal.updateLong(columnName, x);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.crsInternal.updateFloat(columnName, x);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.crsInternal.updateDouble(columnName, x);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.crsInternal.updateBigDecimal(columnName, x);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.crsInternal.updateString(columnName, x);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.crsInternal.updateBytes(columnName, x);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.crsInternal.updateDate(columnName, x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.crsInternal.updateTime(columnName, x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.crsInternal.updateTimestamp(columnName, x);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.crsInternal.updateAsciiStream(columnName, x, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.crsInternal.updateBinaryStream(columnName, x, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        this.crsInternal.updateCharacterStream(columnName, x, length);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.crsInternal.updateObject(columnName, x, scale);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.crsInternal.updateObject(columnName, x);
    }

    @Override
    public void insertRow() throws SQLException {
        this.crsInternal.insertRow();
    }

    @Override
    public void updateRow() throws SQLException {
        this.crsInternal.updateRow();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.crsInternal.deleteRow();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.crsInternal.refreshRow();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.crsInternal.cancelRowUpdates();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.crsInternal.moveToInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.crsInternal.moveToCurrentRow();
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.crsInternal.getStatement();
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return this.crsInternal.getRef(columnIndex);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return this.crsInternal.getBlob(columnIndex);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return this.crsInternal.getClob(columnIndex);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return this.crsInternal.getArray(columnIndex);
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        return this.crsInternal.getRef(columnName);
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        return this.crsInternal.getBlob(columnName);
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        return this.crsInternal.getClob(columnName);
    }

    @Override
    public Array getArray(String columnName) throws SQLException {
        return this.crsInternal.getArray(columnName);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.crsInternal.getDate(columnIndex, cal);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.crsInternal.getDate(columnName, cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.crsInternal.getTime(columnIndex, cal);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.crsInternal.getTime(columnName, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.crsInternal.getTimestamp(columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.crsInternal.getTimestamp(columnName, cal);
    }

    @Override
    public void setMetaData(RowSetMetaData md) throws SQLException {
        this.crsInternal.setMetaData(md);
    }

    @Override
    public ResultSet getOriginal() throws SQLException {
        return this.crsInternal.getOriginal();
    }

    @Override
    public ResultSet getOriginalRow() throws SQLException {
        return this.crsInternal.getOriginalRow();
    }

    @Override
    public void setOriginalRow() throws SQLException {
        this.crsInternal.setOriginalRow();
    }

    @Override
    public int[] getKeyColumns() throws SQLException {
        return this.crsInternal.getKeyColumns();
    }

    @Override
    public void setKeyColumns(int[] cols) throws SQLException {
        this.crsInternal.setKeyColumns(cols);
    }

    @Override
    public void updateRef(int columnIndex, Ref ref) throws SQLException {
        this.crsInternal.updateRef(columnIndex, ref);
    }

    @Override
    public void updateRef(String columnName, Ref ref) throws SQLException {
        this.crsInternal.updateRef(columnName, ref);
    }

    @Override
    public void updateClob(int columnIndex, Clob c) throws SQLException {
        this.crsInternal.updateClob(columnIndex, c);
    }

    @Override
    public void updateClob(String columnName, Clob c) throws SQLException {
        this.crsInternal.updateClob(columnName, c);
    }

    @Override
    public void updateBlob(int columnIndex, Blob b) throws SQLException {
        this.crsInternal.updateBlob(columnIndex, b);
    }

    @Override
    public void updateBlob(String columnName, Blob b) throws SQLException {
        this.crsInternal.updateBlob(columnName, b);
    }

    @Override
    public void updateArray(int columnIndex, Array a) throws SQLException {
        this.crsInternal.updateArray(columnIndex, a);
    }

    @Override
    public void updateArray(String columnName, Array a) throws SQLException {
        this.crsInternal.updateArray(columnName, a);
    }

    @Override
    public void execute() throws SQLException {
        this.crsInternal.execute();
    }

    @Override
    public void execute(Connection conn) throws SQLException {
        this.crsInternal.execute(conn);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return this.crsInternal.getURL(columnIndex);
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.crsInternal.getURL(columnName);
    }

    @Override
    public void writeXml(ResultSet rs, Writer writer) throws SQLException {
        this.wrs = new WebRowSetImpl();
        this.wrs.populate(rs);
        this.wrs.writeXml(writer);
    }

    @Override
    public void writeXml(Writer writer) throws SQLException {
        this.createWebRowSet().writeXml(writer);
    }

    @Override
    public void readXml(Reader reader) throws SQLException {
        this.wrs = new WebRowSetImpl();
        this.wrs.readXml(reader);
        this.crsInternal = (CachedRowSetImpl)((Object)this.wrs);
    }

    @Override
    public void readXml(InputStream iStream) throws SQLException, IOException {
        this.wrs = new WebRowSetImpl();
        this.wrs.readXml(iStream);
        this.crsInternal = (CachedRowSetImpl)((Object)this.wrs);
    }

    @Override
    public void writeXml(OutputStream oStream) throws SQLException, IOException {
        this.createWebRowSet().writeXml(oStream);
    }

    @Override
    public void writeXml(ResultSet rs, OutputStream oStream) throws SQLException, IOException {
        this.wrs = new WebRowSetImpl();
        this.wrs.populate(rs);
        this.wrs.writeXml(oStream);
    }

    private WebRowSet createWebRowSet() throws SQLException {
        if (this.wrs != null) {
            return this.wrs;
        }
        this.wrs = new WebRowSetImpl();
        this.crsInternal.beforeFirst();
        this.wrs.populate(this.crsInternal);
        return this.wrs;
    }

    @Override
    public int getJoinType() throws SQLException {
        if (this.vecJoinType == null) {
            this.setJoinType(1);
        }
        Integer i = this.vecJoinType.get(this.vecJoinType.size() - 1);
        return i;
    }

    @Override
    public void addRowSetListener(RowSetListener listener) {
        this.crsInternal.addRowSetListener(listener);
    }

    @Override
    public void removeRowSetListener(RowSetListener listener) {
        this.crsInternal.removeRowSetListener(listener);
    }

    @Override
    public Collection<?> toCollection() throws SQLException {
        return this.crsInternal.toCollection();
    }

    @Override
    public Collection<?> toCollection(int column) throws SQLException {
        return this.crsInternal.toCollection(column);
    }

    @Override
    public Collection<?> toCollection(String column) throws SQLException {
        return this.crsInternal.toCollection(column);
    }

    @Override
    public CachedRowSet createCopySchema() throws SQLException {
        return this.crsInternal.createCopySchema();
    }

    @Override
    public void setSyncProvider(String providerStr) throws SQLException {
        this.crsInternal.setSyncProvider(providerStr);
    }

    @Override
    public void acceptChanges() throws SyncProviderException {
        this.crsInternal.acceptChanges();
    }

    @Override
    public SyncProvider getSyncProvider() throws SQLException {
        return this.crsInternal.getSyncProvider();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

