/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.AbstractDeploymentUploadHandler;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;

public class DeploymentUploadURLHandler
extends AbstractDeploymentUploadHandler {
    public static final String OPERATION_NAME = "upload-deployment-url";

    private DeploymentUploadURLHandler(ContentRepository repository, AttributeDefinition attribute) {
        super(repository, attribute);
    }

    public static void register(ManagementResourceRegistration registration, ContentRepository repository) {
        registration.registerOperationHandler(DeploymentAttributes.UPLOAD_URL_DEFINITION, (OperationStepHandler)new DeploymentUploadURLHandler(repository, DeploymentAttributes.URL_NOT_NULL));
    }

    @Override
    protected InputStream getContentInputStream(OperationContext operationContext, ModelNode operation) throws OperationFailedException {
        String urlSpec = this.attribute.resolveModelAttribute(operationContext, operation).asString();
        try {
            URL url = new URL(urlSpec);
            return url.openStream();
        }
        catch (MalformedURLException e) {
            throw ServerLogger.ROOT_LOGGER.invalidDeploymentURL(urlSpec, e);
        }
        catch (IOException e) {
            throw ServerLogger.ROOT_LOGGER.problemOpeningStreamFromDeploymentURL(urlSpec, e);
        }
    }
}

