/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.impl;

import org.hibernate.search.analyzer.impl.AnalyzerReference;
import org.hibernate.search.analyzer.impl.LazyRemoteAnalyzer;
import org.hibernate.search.analyzer.impl.RemoteAnalyzer;

public final class RemoteAnalyzerReference
implements AnalyzerReference {
    public static final RemoteAnalyzerReference DEFAULT = new RemoteAnalyzerReference(new LazyRemoteAnalyzer("default"));
    public static final RemoteAnalyzerReference PASS_THROUGH = new RemoteAnalyzerReference(new LazyRemoteAnalyzer("keyword"));
    private RemoteAnalyzer analyzer;

    public RemoteAnalyzerReference(RemoteAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    public RemoteAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    @Override
    public void close() {
        if (this.analyzer != null) {
            this.analyzer.close();
        }
    }

    @Override
    public <T extends AnalyzerReference> boolean is(Class<T> analyzerType) {
        return RemoteAnalyzerReference.class.isAssignableFrom(analyzerType);
    }

    @Override
    public <T extends AnalyzerReference> T unwrap(Class<T> analyzerType) {
        return (T)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("<");
        if (this.analyzer != null) {
            sb.append(this.analyzer);
        }
        sb.append(">");
        return sb.toString();
    }
}

