/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.analysis;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.impl.ScopedLuceneAnalyzer;

public final class ConcurrentlyMutableAnalyzer
extends DelegatingAnalyzerWrapper {
    private final AtomicReference<ScopedLuceneAnalyzer> current = new AtomicReference();

    public ConcurrentlyMutableAnalyzer(Analyzer initialAnalyzer) {
        super((Analyzer.ReuseStrategy)new ResettableReuseStrategy());
        if (initialAnalyzer instanceof ScopedLuceneAnalyzer) {
            this.current.set((ScopedLuceneAnalyzer)initialAnalyzer);
        } else {
            this.current.set(new ScopedLuceneAnalyzer(initialAnalyzer));
        }
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        return (Analyzer)this.current.get();
    }

    public boolean isCompatibleWith(ScopedLuceneAnalyzer analyzer) {
        ScopedLuceneAnalyzer currentAnalyzer = this.current.get();
        return currentAnalyzer.isCompositeOfSameInstances(analyzer);
    }

    public void updateAnalyzer(ScopedLuceneAnalyzer analyzer) {
        this.current.set(analyzer);
    }

    private static final class ResettableReuseStrategy
    extends Analyzer.ReuseStrategy {
        private ResettableReuseStrategy() {
        }

        public Analyzer.TokenStreamComponents getReusableComponents(Analyzer analyzer, String fieldName) {
            if (analyzer instanceof ConcurrentlyMutableAnalyzer) {
                ConcurrentlyMutableAnalyzer cma = (ConcurrentlyMutableAnalyzer)analyzer;
                Analyzer wrappedAnalyzer = cma.getWrappedAnalyzer(fieldName);
                return wrappedAnalyzer.getReuseStrategy().getReusableComponents(wrappedAnalyzer, fieldName);
            }
            throw new AssertionFailure("This ReuseStrategy should only be applied to a ConcurrentlyMutableAnalyzer ");
        }

        public void setReusableComponents(Analyzer analyzer, String fieldName, Analyzer.TokenStreamComponents components) {
            if (!(analyzer instanceof ConcurrentlyMutableAnalyzer)) {
                throw new AssertionFailure("This ReuseStrategy should only be applied to a ConcurrentlyMutableAnalyzer ");
            }
            ConcurrentlyMutableAnalyzer cma = (ConcurrentlyMutableAnalyzer)analyzer;
            Analyzer wrappedAnalyzer = cma.getWrappedAnalyzer(fieldName);
            wrappedAnalyzer.getReuseStrategy().setReusableComponents(analyzer, fieldName, components);
        }
    }
}

