/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.hibernate.search.annotations.FilterCacheModeType;
import org.hibernate.search.cfg.AnalyzerDefMapping;
import org.hibernate.search.cfg.EntityMapping;
import org.hibernate.search.cfg.SearchMapping;

public class FullTextFilterDefMapping {
    private final SearchMapping mapping;
    private final Map<String, Object> fullTextFilterDef;

    public FullTextFilterDefMapping(SearchMapping mapping, String name, Class<?> impl) {
        this.mapping = mapping;
        this.fullTextFilterDef = new HashMap<String, Object>();
        this.fullTextFilterDef.put("name", name);
        this.fullTextFilterDef.put("impl", impl);
        mapping.addFulltextFilterDef(this.fullTextFilterDef);
    }

    public FullTextFilterDefMapping cache(FilterCacheModeType cache) {
        this.fullTextFilterDef.put("cache", (Object)cache);
        return this;
    }

    public FullTextFilterDefMapping fullTextFilterDef(String name, Class<?> impl) {
        return new FullTextFilterDefMapping(this.mapping, name, impl);
    }

    public AnalyzerDefMapping analyzerDef(String name, Class<? extends TokenizerFactory> tokenizerFactory) {
        return new AnalyzerDefMapping(name, tokenizerFactory, this.mapping);
    }

    public EntityMapping entity(Class<?> entityType) {
        return new EntityMapping(entityType, this.mapping);
    }
}

