/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.query.dsl.PhraseMatchingContext;
import org.hibernate.search.query.dsl.PhraseTermination;
import org.hibernate.search.query.dsl.impl.ConnectedMultiFieldsPhraseQueryBuilder;
import org.hibernate.search.query.dsl.impl.FieldContext;
import org.hibernate.search.query.dsl.impl.PhraseQueryContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;

public class ConnectedPhraseMatchingContext
implements PhraseMatchingContext {
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final PhraseQueryContext phraseContext;
    private final List<FieldContext> fieldContexts;
    private int firstOfContext = 0;

    public ConnectedPhraseMatchingContext(String fieldName, PhraseQueryContext phraseContext, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.phraseContext = phraseContext;
        this.fieldContexts = new ArrayList<FieldContext>(4);
        this.fieldContexts.add(new FieldContext(fieldName, queryContext));
    }

    @Override
    public PhraseMatchingContext andField(String field) {
        this.fieldContexts.add(new FieldContext(field, this.queryContext));
        this.firstOfContext = this.fieldContexts.size() - 1;
        return this;
    }

    @Override
    public PhraseTermination sentence(String sentence) {
        this.phraseContext.setSentence(sentence);
        return new ConnectedMultiFieldsPhraseQueryBuilder(this.phraseContext, this.queryCustomizer, this.fieldContexts, this.queryContext);
    }

    @Override
    public PhraseMatchingContext boostedTo(float boost) {
        for (FieldContext fieldContext : this.getCurrentFieldContexts()) {
            fieldContext.getFieldCustomizer().boostedTo(boost);
        }
        return this;
    }

    private List<FieldContext> getCurrentFieldContexts() {
        return this.fieldContexts.subList(this.firstOfContext, this.fieldContexts.size());
    }

    @Override
    public PhraseMatchingContext ignoreAnalyzer() {
        for (FieldContext fieldContext : this.getCurrentFieldContexts()) {
            fieldContext.setIgnoreAnalyzer(true);
        }
        return this;
    }

    @Override
    public PhraseMatchingContext ignoreFieldBridge() {
        return this;
    }
}

